/*
 * Decompiled with CFR 0.152.
 */
package com.pixelduke.window;

import com.pixelduke.window.ThemeWindowManager;
import com.pixelduke.window.WindowUtils;
import com.sun.jna.Function;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import impl.com.pixelduke.window.win32.windows10.AccentPolicy;
import impl.com.pixelduke.window.win32.windows10.AccentState;
import impl.com.pixelduke.window.win32.windows10.WindowCompositionAttribute;
import impl.com.pixelduke.window.win32.windows10.WindowCompositionAttributeData;
import javafx.stage.Window;

public class Win10ThemeWindowManager
implements ThemeWindowManager {
    private Function setWindowCompositionAttribute;
    private boolean previouslyIncrementedWidth = false;

    public Win10ThemeWindowManager() {
        NativeLibrary user32 = NativeLibrary.getInstance((String)"user32");
        this.setWindowCompositionAttribute = user32.getFunction("SetWindowCompositionAttribute");
    }

    @Override
    public void setDarkModeForWindowFrame(Window window, boolean darkMode) {
        WinDef.HMODULE hModule = Kernel32.INSTANCE.GetModuleHandle("uxtheme.dll");
        Kernel32 kernel32 = (Kernel32)Native.loadLibrary(Kernel32.class);
        Function function = Function.getFunction((Pointer)kernel32.GetProcAddress(hModule, 133));
        function.invoke(new Object[]{WindowUtils.getNativeHandleOfStage(window), new WinDef.BOOL(darkMode)});
        WindowCompositionAttributeData data = new WindowCompositionAttributeData();
        data.Attribute = WindowCompositionAttribute.WCA_USEDARKMODECOLORS.getValue();
        data.Data = new WinDef.BOOLByReference(new WinDef.BOOL(darkMode)).getPointer();
        data.SizeOfData = 4;
        this.setWindowCompositionAttribute(window, data);
        this.forceWindowRefresh(window);
    }

    private void forceWindowRefresh(Window window) {
        double WINDOW_WIDTH_INCREMENT = 1.0;
        if (!this.previouslyIncrementedWidth) {
            window.setWidth(window.getWidth() + WINDOW_WIDTH_INCREMENT);
            this.previouslyIncrementedWidth = true;
        } else {
            window.setWidth(window.getWidth() - WINDOW_WIDTH_INCREMENT);
            this.previouslyIncrementedWidth = false;
        }
    }

    public void enableAcrylic(Window window, int opacity, int background) {
        AccentPolicy policy = new AccentPolicy();
        policy.AccentState = AccentState.ACCENT_ENABLE_BLURBEHIND.getValue();
        policy.GradientColor = opacity << 24 | background & 0xFFFFFF;
        policy.write();
        WindowCompositionAttributeData data = new WindowCompositionAttributeData();
        data.Attribute = WindowCompositionAttribute.WCA_ACCENT_POLICY.getValue();
        data.Data = policy.getPointer();
        data.SizeOfData = policy.size();
        data.write();
        WinNT.HRESULT result = this.setWindowCompositionAttribute(window, data);
    }

    private WinNT.HRESULT setWindowCompositionAttribute(Window window, WindowCompositionAttributeData data) {
        return (WinNT.HRESULT)this.setWindowCompositionAttribute.invoke(WinNT.HRESULT.class, new Object[]{WindowUtils.getNativeHandleOfStage(window), data});
    }
}

