/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.views;

import de.mallongigi.podcast.episode.navigation.PodcastEpisodeModel;
import de.mallongigi.singleton.Singleton;
import de.mallongigi.views.ApplicationViewNames;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;

@Singleton
public final class ApplicationViewsModel {
    private BooleanProperty podcastDisableProperty = new SimpleBooleanProperty();
    private BooleanProperty mediaDisableProperty = new SimpleBooleanProperty(true);
    private BooleanProperty detailDisableProperty = new SimpleBooleanProperty(true);
    private BooleanProperty searchDisableProperty = new SimpleBooleanProperty(true);
    private BooleanProperty preferencesDisableProperty = new SimpleBooleanProperty(true);
    private ObjectProperty<ApplicationViewNames> selectedViewProperty = new SimpleObjectProperty();
    private ObjectProperty<PodcastEpisodeModel> episodeProperty = new SimpleObjectProperty();

    private ApplicationViewsModel() {
    }

    public void disableView(ApplicationViewNames view, boolean state) {
        switch (view) {
            case Podcasts: {
                this.podcastDisableProperty.set(state);
                break;
            }
            case Mediaplayer: {
                this.mediaDisableProperty.set(state);
                break;
            }
            case Details: {
                this.detailDisableProperty.set(state);
                break;
            }
            case Search: {
                this.searchDisableProperty.set(state);
                break;
            }
            case Preferences: {
                this.preferencesDisableProperty.set(state);
            }
        }
    }

    public void playEpisode(PodcastEpisodeModel episode) {
        this.episodeProperty.set((Object)episode);
    }

    public void clearPlayer() {
        this.episodeProperty.set(null);
    }

    public void setView(ApplicationViewNames view) {
        this.selectedViewProperty.set((Object)view);
    }

    public ObjectProperty<ApplicationViewNames> selectedViewProperty() {
        return this.selectedViewProperty;
    }

    BooleanProperty mediaplayerTabDisableProperty() {
        return this.mediaDisableProperty;
    }

    BooleanProperty detailTabDisableProperty() {
        return this.detailDisableProperty;
    }

    ObjectProperty<PodcastEpisodeModel> currentPodcastEpisodeProperty() {
        return this.episodeProperty;
    }
}

