/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.views;

import de.mallongigi.dialog.ErrorDialog;
import de.mallongigi.mediaplayer.MediaPlayerProxy;
import de.mallongigi.podcast.channel.model.PodcastNavigationViewType;
import de.mallongigi.podcast.channel.navigation.PodcastChannelModel;
import de.mallongigi.podcast.detailinformation.DetailInformationController;
import de.mallongigi.podcast.episode.navigation.PodcastEpisodeModel;
import de.mallongigi.podcast.search.PodcastSearchPane;
import de.mallongigi.podcast.ui.PodcastPane;
import de.mallongigi.resource.icons.DefaultIcons;
import de.mallongigi.resource.icons.IconFactory;
import de.mallongigi.resource.language.LanguageKeys;
import de.mallongigi.resource.language.LanguageResource;
import de.mallongigi.settings.SettingPane;
import de.mallongigi.singleton.Initialization;
import de.mallongigi.singleton.Inject;
import de.mallongigi.singleton.Singleton;
import de.mallongigi.toolbar.ApplicationToolbarModel;
import de.mallongigi.views.ApplicationViewNames;
import de.mallongigi.views.ApplicationViewsModel;
import de.mallongigi.views.FXMLViewFactory;
import javafx.animation.FadeTransition;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.SingleSelectionModel;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.layout.Pane;
import javafx.util.Duration;

@Singleton
public final class ApplicationViews
extends TabPane {
    @Inject
    private LanguageResource languageResource;
    @Inject
    private ApplicationViewsModel viewModel;
    @Inject
    private ApplicationToolbarModel toolbarModel;
    @Inject
    private IconFactory iconFactory;
    @Inject
    private SettingPane settingPane;
    @Inject
    private PodcastPane podcastPane;
    private Tab podcastTab;
    private Tab preferencesTab;
    private Tab mediaPlayerTab;
    private Tab podcastInformationTab;
    private MediaPlayerProxy mediaPlayer;
    private FXMLViewFactory<DetailInformationController, Pane> podcastInformationView = new FXMLViewFactory("/de/mallongigi/fxml/detailinformation/detailInformation.fxml");
    private boolean switching = false;

    private ApplicationViews() {
    }

    @Initialization
    private void init() {
        this.setTabClosingPolicy(TabPane.TabClosingPolicy.UNAVAILABLE);
        this.setSide(Side.LEFT);
        this.setTabClosingPolicy(TabPane.TabClosingPolicy.UNAVAILABLE);
        this.setSide(Side.LEFT);
        this.podcastTab = new Tab(this.languageResource.messageForKey(LanguageKeys.tabLabelPodcasts), (Node)this.podcastPane);
        this.podcastTab.setGraphic(this.iconFactory.create(DefaultIcons.Main, 16));
        this.preferencesTab = new Tab(this.languageResource.messageForKey(LanguageKeys.preferences), (Node)this.settingPane);
        this.preferencesTab.setGraphic(this.iconFactory.create(DefaultIcons.Preferences, 16));
        this.mediaPlayerTab = new Tab(this.languageResource.messageForKey(LanguageKeys.tabLabelMedia));
        this.mediaPlayer = new MediaPlayerProxy(this.mediaPlayerTab);
        this.mediaPlayer.init();
        this.mediaPlayerTab.setGraphic(this.iconFactory.create(DefaultIcons.mediaPlayer, 16));
        this.podcastInformationTab = new Tab(this.languageResource.messageForKey(LanguageKeys.podcastInformation), (Node)this.podcastInformationView.create().getComponent());
        this.podcastInformationTab.setGraphic(this.iconFactory.create(DefaultIcons.Information, 16));
        Tab searchTab = new Tab(this.languageResource.messageForKey(LanguageKeys.search), (Node)new PodcastSearchPane().getRoot());
        searchTab.setGraphic(this.iconFactory.create(DefaultIcons.search, 16));
        this.getTabs().addAll((Object[])new Tab[]{this.podcastTab, this.mediaPlayerTab, this.podcastInformationTab, searchTab, this.preferencesTab});
        this.preferencesTab.disableProperty().bind((ObservableValue)this.toolbarModel.getInProgressModeProperty());
        this.mediaPlayerTab.disableProperty().bind((ObservableValue)this.viewModel.mediaplayerTabDisableProperty());
        this.podcastInformationTab.disableProperty().bind((ObservableValue)this.viewModel.detailTabDisableProperty());
        this.viewModel.selectedViewProperty().addListener((o, oldValue, newValue) -> {
            SingleSelectionModel selectionModel = this.getSelectionModel();
            switch (newValue) {
                case Podcasts: {
                    selectionModel.select((Object)this.podcastTab);
                    break;
                }
                case Mediaplayer: {
                    selectionModel.select((Object)this.mediaPlayerTab);
                    break;
                }
                case Details: {
                    selectionModel.select((Object)this.podcastInformationTab);
                    break;
                }
                case Search: {
                    selectionModel.select(3);
                    break;
                }
                case Preferences: {
                    selectionModel.select((Object)this.preferencesTab);
                }
            }
        });
        this.getSelectionModel().selectedIndexProperty().addListener((o, oldValue, newValue) -> {
            switch (newValue.intValue()) {
                case 0: {
                    this.viewModel.setView(ApplicationViewNames.Podcasts);
                    break;
                }
                case 1: {
                    this.viewModel.setView(ApplicationViewNames.Mediaplayer);
                    break;
                }
                case 2: {
                    this.viewModel.setView(ApplicationViewNames.Details);
                    break;
                }
                case 3: {
                    this.viewModel.setView(ApplicationViewNames.Search);
                    break;
                }
                case 4: {
                    this.viewModel.setView(ApplicationViewNames.Preferences);
                }
            }
        });
        this.getSelectionModel().selectedItemProperty().addListener((obs, oldTab, newTab) -> {
            if (this.switching) {
                return;
            }
            this.switching = true;
            if (oldTab != null && oldTab.getContent() != null) {
                FadeTransition fadeOut = new FadeTransition(Duration.millis((double)300.0), oldTab.getContent());
                fadeOut.setFromValue(1.0);
                fadeOut.setToValue(0.0);
                fadeOut.setOnFinished(e -> {
                    this.getSelectionModel().select(newTab);
                    if (newTab.getContent() != null) {
                        newTab.getContent().setOpacity(0.0);
                        FadeTransition fadeIn = new FadeTransition(Duration.millis((double)300.0), newTab.getContent());
                        fadeIn.setFromValue(0.0);
                        fadeIn.setToValue(1.0);
                        fadeIn.setOnFinished(ev -> {
                            this.switching = false;
                        });
                        fadeIn.play();
                    } else {
                        this.switching = false;
                    }
                });
                fadeOut.play();
                this.getSelectionModel().select(oldTab);
            } else {
                this.switching = false;
            }
        });
        this.toolbarModel.getSelectedChannel().addListener((o, o\u00f6dValue, newValue) -> {
            boolean isView = newValue.getChannelType() == PodcastNavigationViewType.PodcastView;
            this.viewModel.disableView(ApplicationViewNames.Details, isView);
            this.podcastInformationView.getController().setChannelModel((PodcastChannelModel)newValue);
        });
        this.viewModel.currentPodcastEpisodeProperty().addListener((o, oldValue, newValue) -> {
            try {
                if (newValue != null) {
                    this.mediaPlayer.setEpisode((PodcastEpisodeModel)newValue);
                }
            }
            catch (Exception e) {
                new ErrorDialog().show(LanguageKeys.errorMessageOpenFolder, (Throwable)e);
            }
        });
    }
}

