/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.ui.elements;

import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Tooltip;
import javafx.util.Duration;

public final class UITooltip {
    private int width = 150;
    private final Tooltip tooltip;

    public UITooltip(String text) {
        this.tooltip = new Tooltip(text);
    }

    public UITooltip(int width) {
        this("");
        this.width = width;
    }

    public UITooltip(String text, int width) {
        this(text);
        this.width = width;
    }

    public void install(Node element) {
        this.tooltip.setWrapText(true);
        this.tooltip.setPrefWidth((double)this.width);
        this.tooltip.setShowDuration(new Duration(60000.0));
        Tooltip.install((Node)element, (Tooltip)this.tooltip);
    }

    public void setText(String text) {
        this.tooltip.setText(text);
    }

    public void bind(StringProperty property) {
        this.tooltip.textProperty().bind((ObservableValue)property);
    }
}

