/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.ui.elements;

import de.mallongigi.dialog.ErrorDialog;
import de.mallongigi.resource.language.LanguageKeys;
import de.mallongigi.singleton.Container;
import java.awt.Desktop;
import java.net.URI;
import javafx.event.EventHandler;
import javafx.scene.Cursor;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;

public final class UILink
extends Label {
    public UILink(String text) {
        super(text);
        Container.inject((Object)this);
        this.setCursor(Cursor.HAND);
        this.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent e) {
                String url = UILink.this.getText();
                if (url == null || url.length() == 0) {
                    return;
                }
                Desktop desktop = Desktop.getDesktop();
                try {
                    desktop.browse(new URI(url));
                }
                catch (Exception e1) {
                    new ErrorDialog().show(LanguageKeys.errorMessageExecuteBrowser, e1, url);
                }
            }
        });
    }
}

