/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.toolbar.usbstick;

import de.mallongigi.singleton.Container;
import de.mallongigi.toolbar.usbstick.USBStickDetailInformationService;
import java.io.File;
import java.lang.runtime.SwitchBootstraps;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;

public final class USBComponentModel {
    private final StringProperty path;
    private final StringProperty fileSize = new SimpleStringProperty("?");
    private StringProperty freeDiskSpaceSpace = new SimpleStringProperty("?");
    private final StringProperty completeDuration = new SimpleStringProperty("?");
    private final BooleanProperty copyMode = new SimpleBooleanProperty(false);
    private int copyModeCount = 0;
    private final USBStickDetailInformationService service;

    public USBComponentModel(StringProperty path) {
        this.path = path;
        this.service = new USBStickDetailInformationService(this);
        Container.inject(this);
    }

    public StringProperty pathProperty() {
        return this.path;
    }

    public StringProperty fileSizeProperty() {
        return this.fileSize;
    }

    public StringProperty freeDiskSpaceProperty() {
        return this.freeDiskSpaceSpace;
    }

    void addCopyModeListener(ChangeListener<? super Boolean> listener) {
        this.copyMode.addListener(listener);
    }

    boolean isCopyModus() {
        return this.copyMode.get();
    }

    public void setCopyMode(boolean state) {
        if (state) {
            ++this.copyModeCount;
            this.copyMode.set(state);
        } else {
            --this.copyModeCount;
            if (this.copyModeCount <= 0) {
                this.copyMode.set(false);
                this.copyModeCount = 0;
                this.service.setSyncAlwaysMode();
            }
        }
    }

    public StringProperty getCompleteDuration() {
        return this.completeDuration;
    }

    void setFileSize(long fileSize) {
        this.fileSize.set((Object)String.valueOf(fileSize));
    }

    void setFreeSpace(String freeSpace) {
        this.freeDiskSpaceSpace.set((Object)freeSpace);
    }

    void setCompleteDuration(String completeDuration) {
        this.completeDuration.set((Object)completeDuration);
    }

    void refreshInSyncMode() {
        this.service.setSyncAlwaysMode();
        this.refresh();
    }

    public void refresh() {
        if (!new File((String)this.path.get()).exists()) {
            return;
        }
        if (!this.service.isRunning()) {
            this.service.restart();
        }
    }

    public int hashCode() {
        return ((String)this.pathProperty().get()).hashCode();
    }

    public boolean equals(Object obj) {
        Object object = obj;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{USBComponentModel.class}, (Object)object, n)) {
            case 0: {
                USBComponentModel m = (USBComponentModel)object;
                return ((String)this.path.get()).equals(m.path.get());
            }
        }
        return false;
    }
}

