/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.toolbar;

import de.mallongigi.podcast.channel.navigation.PodcastChannelModel;
import de.mallongigi.settings.model.ApplicationSettings;
import de.mallongigi.singleton.Inject;
import de.mallongigi.singleton.Singleton;
import de.mallongigi.toolbar.USBComponentModelList;
import de.mallongigi.toolbar.usbstick.USBComponentModel;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;

@Singleton
public final class ApplicationToolbarModel {
    private final USBComponentModelList usbList = new USBComponentModelList();
    private final BooleanProperty inProgressMode = new SimpleBooleanProperty(true);
    private final BooleanProperty noNewVersionAvailable = new SimpleBooleanProperty(true);
    private final ObjectProperty<PodcastChannelModel> selectedChannel = new SimpleObjectProperty();
    @Inject
    private ApplicationSettings settings;

    private ApplicationToolbarModel() {
    }

    public void setProgressMode(boolean state) {
        this.inProgressMode.set(state);
    }

    public void setNewMallongigiVersionAvailable(boolean state) {
        this.noNewVersionAvailable.set(!state);
    }

    public void setSelectedChannel(PodcastChannelModel selectedChannel) {
        this.selectedChannel.set((Object)selectedChannel);
    }

    public BooleanProperty getInProgressModeProperty() {
        return this.inProgressMode;
    }

    BooleanProperty getNewMallongigiVersionAvailableProperty() {
        return this.noNewVersionAvailable;
    }

    public ObjectProperty<PodcastChannelModel> getSelectedChannel() {
        return this.selectedChannel;
    }

    public USBComponentModelList getUsbList() {
        return this.usbList;
    }

    public void refresh(PodcastChannelModel channelModel) {
        for (USBComponentModel m : this.usbList.getUSBComponents()) {
            if (((String)m.pathProperty().get()).equals(channelModel.getUsbPath())) {
                m.refresh();
            }
            if (channelModel.getUsbPath() != null && !channelModel.getUsbPath().isEmpty() || !((String)m.pathProperty().get()).equals(this.settings.getUsbStickPathProperty().get())) continue;
            m.refresh();
        }
    }

    public void refreshAll() {
        for (USBComponentModel m : this.usbList.getUSBComponents()) {
            m.refresh();
        }
    }
}

