/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.toolbar;

import de.mallongigi.dialog.ErrorDialog;
import de.mallongigi.dialog.PodcastAddFeedDialog;
import de.mallongigi.file.FileUtil;
import de.mallongigi.file.chooser.FileChooserInterface;
import de.mallongigi.opml.ImportOPMLService;
import de.mallongigi.opml.OPMLExport;
import de.mallongigi.platform.OSPlatform;
import de.mallongigi.podcast.channel.model.PodcastChannelContainer;
import de.mallongigi.podcast.channel.model.PodcastNavigationViewType;
import de.mallongigi.podcast.channel.navigation.PodcastChannelModel;
import de.mallongigi.podcast.channel.navigation.PodcastChannelNavigationModel;
import de.mallongigi.podcast.channel.ui.AddPodcastChannelService;
import de.mallongigi.podcast.channel.ui.ManuelRefreshPodcastService;
import de.mallongigi.podcast.channel.ui.RefreshAutomaticServices;
import de.mallongigi.resource.icons.DefaultIcons;
import de.mallongigi.resource.icons.IconColors;
import de.mallongigi.resource.icons.IconFactory;
import de.mallongigi.resource.language.LanguageKeys;
import de.mallongigi.resource.language.LanguageResource;
import de.mallongigi.settings.model.ApplicationSettings;
import de.mallongigi.singleton.Component;
import de.mallongigi.singleton.Initialization;
import de.mallongigi.singleton.Inject;
import de.mallongigi.toolbar.ApplicationToolbarModel;
import de.mallongigi.toolbar.usbstick.USBComponentModel;
import de.mallongigi.toolbar.usbstick.USBStickResourceViewController;
import de.mallongigi.ui.elements.UIButton;
import de.mallongigi.ui.style.Styles;
import de.mallongigi.views.FXMLViewFactory;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.concurrent.Worker;
import javafx.event.EventHandler;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Separator;
import javafx.scene.control.ToolBar;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;

@Component
public final class ApplicationToolbar
extends ToolBar {
    private static final Logger LOG = Logger.getLogger(ApplicationToolbar.class.getName());
    @Inject
    private LanguageResource languageResource;
    @Inject
    private PodcastChannelContainer podcastChannelContainer;
    @Inject
    private ApplicationToolbarModel toolbarModel;
    @Inject
    private AddPodcastChannelService addPodcastChannelService;
    @Inject
    private ImportOPMLService importOPMLService;
    @Inject
    private RefreshAutomaticServices registryAutomaticServices;
    @Inject
    private ManuelRefreshPodcastService manuelRefreshPodcastService;
    @Inject(safety=false)
    private Stage primaryStage;
    @Inject
    private PodcastChannelNavigationModel podcastChannelNavigationModel;
    @Inject(safety=false)
    private FileChooserInterface fileChooser;
    @Inject
    private OPMLExport opmlExport;
    @Inject
    private Styles styles;
    @Inject
    private OSPlatform osPlatform;
    @Inject
    private IconFactory iconFactory;
    @Inject
    private ApplicationSettings settings;

    private ApplicationToolbar() {
    }

    @Initialization
    private void init() {
        final UIButton deleteRssFeedButton = this.createDeletePodcastButton();
        final UIButton refreshPodcastButton = this.createRefreshPodcastButton();
        final UIButton editPodcastChannel = this.createEditPodcastButton();
        UIButton updateMallongigi = this.createUpdateButton();
        final HBox usbStickDetails = new HBox();
        this.toolbarModel.getUsbList().getUsbListProperty().addListener((ListChangeListener)new ListChangeListener<USBComponentModel>(){

            public void onChanged(ListChangeListener.Change<? extends USBComponentModel> c) {
                if (!c.next()) {
                    return;
                }
                ObservableList list = c.getList();
                usbStickDetails.getChildren().clear();
                for (USBComponentModel m : list) {
                    try {
                        if (!Files.exists(Paths.get((String)m.pathProperty().get(), new String[0]), new LinkOption[0])) {
                            return;
                        }
                        USBStickResourceViewController controller = new USBStickResourceViewController(m);
                        FXMLViewFactory factory = new FXMLViewFactory("/de/mallongigi/fxml/usbstick/usbStickdetails.fxml", controller);
                        factory.create();
                        HBox usbComponente = (HBox)factory.getComponent();
                        usbStickDetails.getChildren().addAll((Object[])new Node[]{usbComponente, new Separator(Orientation.VERTICAL)});
                        m.refresh();
                    }
                    catch (Exception e) {
                        LOG.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
            }
        });
        this.getItems().addAll((Object[])new Node[]{this.createAddPodcastButton(), editPodcastChannel, this.createSeparator(), this.createRefreshAllButton(), refreshPodcastButton, this.createSeparator(), deleteRssFeedButton, this.createSeparator(), updateMallongigi, this.createSeparator(), this.createExchangeArea(), this.createSeparator(), usbStickDetails});
        this.toolbarModel.getSelectedChannel().addListener((ChangeListener)new ChangeListener<PodcastChannelModel>(){

            public void changed(ObservableValue<? extends PodcastChannelModel> observable, PodcastChannelModel oldValue, PodcastChannelModel newValue) {
                boolean isView = newValue.getChannelType() == PodcastNavigationViewType.PodcastView;
                deleteRssFeedButton.setDisable(isView);
                refreshPodcastButton.setDisable(isView);
                editPodcastChannel.setDisable(isView);
            }
        });
    }

    private Separator createSeparator() {
        return new Separator(Orientation.VERTICAL);
    }

    private UIButton createEditPodcastButton() {
        UIButton editPodcastButton = new UIButton(LanguageKeys.editPodcastChannel, DefaultIcons.editPodcastChannel);
        editPodcastButton.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent e) {
                String url = new PodcastAddFeedDialog().insertPodcastUrl(LanguageKeys.editPodcastChannel);
                if (url != null) {
                    PodcastChannelModel model = ApplicationToolbar.this.podcastChannelNavigationModel.getSelectedChannel();
                    model.setPodcastFeedUrl(url);
                    ApplicationToolbar.this.refreshSelectedPodcast();
                }
            }
        });
        return editPodcastButton;
    }

    private UIButton createAddPodcastButton() {
        UIButton addRssFeedButton = new UIButton(LanguageKeys.addPodcast, DefaultIcons.AddPodcast);
        addRssFeedButton.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent e) {
                String url = new PodcastAddFeedDialog().insertPodcastUrl(LanguageKeys.editPodcastChannel);
                if (url != null) {
                    ApplicationToolbar.this.addPodcastChannelService.setUrl(url).setShowAlternative(true).restart();
                }
            }
        });
        return addRssFeedButton;
    }

    private VBox createExchangeArea() {
        VBox wrapper = new VBox();
        wrapper.setAlignment(Pos.CENTER);
        UIButton importButton = new UIButton(LanguageKeys.importData, DefaultIcons.Import, 16);
        importButton.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent e) {
                ApplicationToolbar.this.podcastChannelNavigationModel.clearFilter();
                Path file = ApplicationToolbar.this.fileChooser.select(ApplicationToolbar.this.languageResource.messageForKey(LanguageKeys.opml) + " (*.opml)", "*.opml");
                if (file != null) {
                    ApplicationToolbar.this.importOPMLService.setFile(file).start();
                }
            }
        });
        UIButton exportButton = new UIButton(LanguageKeys.exportData, DefaultIcons.Export, 16);
        exportButton.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent e) {
                ApplicationToolbar.this.podcastChannelNavigationModel.clearFilter();
                FileChooser fileChooser = new FileChooser();
                FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter(ApplicationToolbar.this.languageResource.messageForKey(LanguageKeys.opml) + " (*.opml)", new String[]{"*.opml"});
                fileChooser.getExtensionFilters().add((Object)extFilter);
                File file = fileChooser.showSaveDialog((Window)ApplicationToolbar.this.primaryStage);
                if (file != null) {
                    ApplicationToolbar.this.opmlExport.setFile(file.toPath()).start();
                }
            }
        });
        wrapper.getChildren().addAll((Object[])new Node[]{importButton, exportButton});
        return wrapper;
    }

    private UIButton createDeletePodcastButton() {
        UIButton deleteButton = new UIButton(LanguageKeys.deletePodcats, DefaultIcons.Delete);
        deleteButton.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent e) {
                ApplicationToolbar.this.podcastChannelNavigationModel.clearFilter();
                PodcastChannelModel model = ApplicationToolbar.this.podcastChannelNavigationModel.getSelectedChannel();
                Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
                ApplicationToolbar.this.styles.setStyle(alert.getDialogPane());
                ApplicationToolbar.this.styles.setWindowIcon(alert.getDialogPane(), DefaultIcons.Delete);
                alert.setGraphic(ApplicationToolbar.this.iconFactory.create(DefaultIcons.Delete, 48, IconColors.Error));
                alert.setTitle(ApplicationToolbar.this.languageResource.messageForKey(LanguageKeys.deletePodcats));
                alert.setHeaderText(ApplicationToolbar.this.languageResource.messageForKey(LanguageKeys.deletePodcastMessage, model.getTitle()));
                alert.setContentText(ApplicationToolbar.this.languageResource.messageForKey(LanguageKeys.question));
                ApplicationToolbar.this.osPlatform.setDarkMode((Dialog<?>)alert);
                Optional result = alert.showAndWait();
                if (result.get() == ButtonType.OK) {
                    try {
                        ApplicationToolbar.this.podcastChannelContainer.remove(model);
                        Path directory = Paths.get(model.getLocaleDirectory(), new String[0]);
                        Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(this){

                            @Override
                            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                                FileUtil.delete(file);
                                return FileVisitResult.CONTINUE;
                            }

                            @Override
                            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                                FileUtil.delete(dir);
                                return FileVisitResult.CONTINUE;
                            }
                        });
                    }
                    catch (IOException e1) {
                        new ErrorDialog().show(LanguageKeys.errorMessageDeleteFileSystem, e1, model.getLocaleDirectory());
                    }
                }
            }
        });
        return deleteButton;
    }

    private UIButton createRefreshPodcastButton() {
        UIButton button = new UIButton(LanguageKeys.refreshPodcast, DefaultIcons.RefreshPodcastChannel);
        button.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent e) {
                ApplicationToolbar.this.refreshSelectedPodcast();
            }
        });
        return button;
    }

    private UIButton createRefreshAllButton() {
        UIButton button = new UIButton(LanguageKeys.refreshPodcastAll, DefaultIcons.RefreshAll);
        button.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent e) {
                if (ApplicationToolbar.this.registryAutomaticServices.getState() == Worker.State.RUNNING) {
                    return;
                }
                ApplicationToolbar.this.registryAutomaticServices.restart();
            }
        });
        return button;
    }

    private UIButton createUpdateButton() {
        UIButton button = new UIButton(LanguageKeys.updateMallongigi, DefaultIcons.updateAvalible);
        button.disableProperty().bind((ObservableValue)this.toolbarModel.getNewMallongigiVersionAvailableProperty());
        button.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(this){

            public void handle(MouseEvent e) {
                String url = "http://www.mallongigi.de";
                Desktop desktop = Desktop.getDesktop();
                try {
                    desktop.browse(new URI(url));
                }
                catch (Exception e1) {
                    new ErrorDialog().show(LanguageKeys.errorMessageExecuteBrowser, e1, url);
                }
            }
        });
        return button;
    }

    private void refreshSelectedPodcast() {
        this.manuelRefreshPodcastService.setChannel(this.podcastChannelNavigationModel.getSelectedChannel());
        this.manuelRefreshPodcastService.restart();
    }
}

