/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.time;

import de.mallongigi.singleton.Singleton;
import java.text.SimpleDateFormat;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

@Singleton
public final class DateTimeConverter {
    private static Locale[] locales = new Locale[]{Locale.US, Locale.GERMANY, Locale.UK};
    private static final Map<String, String> DATE_FORMAT_REGEXPS = new HashMap<String, String>(){
        {
            this.put("^\\d{8}$", "yyyyMMdd");
            this.put("^\\d{1,2}-\\d{1,2}-\\d{4}$", "dd-MM-yyyy");
            this.put("^\\d{4}-\\d{1,2}-\\d{1,2}$", "yyyy-MM-dd");
            this.put("^\\d{1,2}/\\d{1,2}/\\d{4}$", "MM/dd/yyyy");
            this.put("^\\d{4}/\\d{1,2}/\\d{1,2}$", "yyyy/MM/dd");
            this.put("^\\d{1,2}\\s[a-z]{3}\\s\\d{4}$", "dd MMM yyyy");
            this.put("^\\d{1,2}\\s[a-z]{4,}\\s\\d{4}$", "dd MMMM yyyy");
            this.put("^\\d{12}$", "yyyyMMddHHmm");
            this.put("^\\d{8}\\s\\d{4}$", "yyyyMMdd HHmm");
            this.put("^\\d{1,2}-\\d{1,2}-\\d{4}\\s\\d{1,2}:\\d{2}$", "dd-MM-yyyy HH:mm");
            this.put("^\\d{4}-\\d{1,2}-\\d{1,2}\\s\\d{1,2}:\\d{2}$", "yyyy-MM-dd HH:mm");
            this.put("^\\d{1,2}/\\d{1,2}/\\d{4}\\s\\d{1,2}:\\d{2}$", "MM/dd/yyyy HH:mm");
            this.put("^\\d{4}/\\d{1,2}/\\d{1,2}\\s\\d{1,2}:\\d{2}$", "yyyy/MM/dd HH:mm");
            this.put("^\\d{1,2}\\s[a-z]{3}\\s\\d{4}\\s\\d{1,2}:\\d{2}$", "dd MMM yyyy HH:mm");
            this.put("^\\d{1,2}\\s[a-z]{4,}\\s\\d{4}\\s\\d{1,2}:\\d{2}$", "dd MMMM yyyy HH:mm");
            this.put("^\\d{14}$", "yyyyMMddHHmmss");
            this.put("^\\d{8}\\s\\d{6}$", "yyyyMMdd HHmmss");
            this.put("^\\d{1,2}-\\d{1,2}-\\d{4}\\s\\d{1,2}:\\d{2}:\\d{2}$", "dd-MM-yyyy HH:mm:ss");
            this.put("^\\d{4}-\\d{1,2}-\\d{1,2}\\s\\d{1,2}:\\d{2}:\\d{2}$", "yyyy-MM-dd HH:mm:ss");
            this.put("^\\d{1,2}/\\d{1,2}/\\d{4}\\s\\d{1,2}:\\d{2}:\\d{2}$", "MM/dd/yyyy HH:mm:ss");
            this.put("^\\d{4}/\\d{1,2}/\\d{1,2}\\s\\d{1,2}:\\d{2}:\\d{2}$", "yyyy/MM/dd HH:mm:ss");
            this.put("^\\d{1,2}\\s[a-z]{3}\\s\\d{4}\\s\\d{1,2}:\\d{2}:\\d{2}$", "dd MMM yyyy HH:mm:ss");
            this.put("^\\d{1,2}\\s[a-z]{4,}\\s\\d{4}\\s\\d{1,2}:\\d{2}:\\d{2}$", "dd MMMM yyyy HH:mm:ss");
            this.put("^\\D{3}, \\d{2} \\D{3} \\d{4} \\d{2}:\\d{2}:\\d{2} \\p{Punct}\\d{4}$", "E, d MMM yyyy HH:mm:ss Z");
            this.put("^\\D{3}, \\d{2} \\D{3} \\d{4} \\d{2}:\\d{2}.\\d{2} \\p{Punct}\\d{4}$", "E, d MMM yyyy HH:mm.ss Z");
            this.put("^\\D{3}, \\d{1} \\D{3} \\d{4} \\d{2}:\\d{2}:\\d{2} \\p{Punct}\\d{4}$", "E, d MMM yyyy HH:mm:ss Z");
        }
    };

    private DateTimeConverter() {
    }

    private String determineDateFormat(String dateString) {
        for (String regexp : DATE_FORMAT_REGEXPS.keySet()) {
            if (!dateString.toLowerCase().matches(regexp)) continue;
            return DATE_FORMAT_REGEXPS.get(regexp);
        }
        return "E, dd MMM yyyy HH:mm:ss Z";
    }

    public Date convert(String dateString) {
        Object date = dateString;
        if (((String)date).indexOf(",") == 2) {
            date = "Wed" + ((String)date).substring(2);
        }
        String pattern = this.determineDateFormat((String)date);
        for (Locale l : locales) {
            Date d = this.convert(dateString, pattern, l);
            if (d == null) continue;
            return d;
        }
        return new Date();
    }

    private Date convert(String date, String pattern, Locale locale) {
        try {
            return new SimpleDateFormat(pattern, locale).parse(date);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String convert(long value, Time time) {
        int factor = 0;
        switch (time.ordinal()) {
            case 0: {
                factor = 1;
                break;
            }
            case 1: {
                factor = 1000;
            }
        }
        int h = (int)(value / (long)factor / 3600L);
        int m = (int)(value / (long)factor / 60L % 60L);
        int s = (int)(value / (long)factor % 60L);
        return String.format("%02d:%02d:%02d", h, m, s);
    }

    public String convert(double value, Time time) {
        return this.convert((long)value, time);
    }

    public DateTimeFormatter getDurationFormatter() {
        return DateTimeFormatter.ofPattern("HH:mm:ss");
    }

    public LocalTime convertDurationTime(String time) {
        Object duration = switch (time.length()) {
            case 1 -> "00:00:00";
            case 2 -> "00:00:" + time;
            case 5 -> "00:" + time;
            default -> time;
        };
        DateTimeFormatter formatter = this.getDurationFormatter();
        LocalTime result = LocalTime.from(formatter.parse((CharSequence)duration));
        return result;
    }

    public static enum Time {
        Seconds,
        Milliseconds;

    }
}

