/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.singleton;

import de.mallongigi.singleton.Component;
import de.mallongigi.singleton.ComponentFactory;
import de.mallongigi.singleton.ComponentInstance;
import de.mallongigi.singleton.CreateSingletons;
import de.mallongigi.singleton.InitialisationErrorListener;
import de.mallongigi.singleton.Inject;
import de.mallongigi.singleton.Singleton;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public final class Container {
    private static final Logger LOG = Logger.getLogger(Container.class.getName());
    private InitialisationErrorListener initialisationErrorListener;
    private static Container instance;
    private final Map<Class<?>, ComponentInstance> components = new HashMap();
    private final List<InjectLaterObject> laterInjectStack = new ArrayList<InjectLaterObject>();

    private Container() {
    }

    private void addInternal(ComponentInstance component) {
        Class<?>[] interfaces;
        if (component == null) {
            throw new RuntimeException("Cant registry null as Singleton.");
        }
        Class<?> type = component.getComponent().getClass();
        if (this.components.containsKey(type)) {
            throw new RuntimeException(String.valueOf(type) + " has a Singleton Instance in Container. Not Add the new Instance");
        }
        LOG.fine("Registry " + String.valueOf(type) + " as new Component.");
        this.components.put(type, component);
        for (Class<?> i : interfaces = component.getComponent().getClass().getInterfaces()) {
            if (this.components.containsKey(i)) {
                throw new RuntimeException(String.valueOf(i) + " has a Singleton Instanc in Container. Not Add the new Instance");
            }
            this.components.put(i, component);
        }
        if (!Container.instance.laterInjectStack.isEmpty()) {
            instance.injectLater(component.getComponent());
        }
        this.doInitializationMethod(component);
        this.doInitializationMethod();
    }

    private void inject(ComponentInstance component) {
        try {
            for (Field f : component.getInjectedFields()) {
                Inject inject = f.getAnnotation(Inject.class);
                Class<?> type = f.getType();
                f.setAccessible(true);
                Object value = f.get(component.getComponent());
                if (value != null) continue;
                Component annotation = type.getAnnotation(Component.class);
                if (inject.safety() && annotation == null && type.getAnnotation(Singleton.class) == null) {
                    String error = "The field \"" + f.getName() + "\" in class " + instance.getClass().getName() + " defines class " + type.getName() + " as an inject. However, this class is not defined as a @Singleton or @Component. Options include defining the class as a @Component or @Singleton, or setting the \"unsafe\" attribute to true in the @Inject.";
                    this.initialisationErrorListener.error("error", new Exception(error), LOG);
                }
                if (annotation != null && !annotation.singleton()) {
                    ComponentInstance ci = new ComponentFactory().create(type);
                    f.setAccessible(true);
                    f.set(component.getComponent(), ci.getComponent());
                    this.inject(ci);
                    this.addInternal(ci);
                    continue;
                }
                ComponentInstance s = this.components.get(type);
                if (s == null) {
                    this.laterInjectStack.add(new InjectLaterObject(component.getComponent(), f));
                    continue;
                }
                f.setAccessible(true);
                f.set(component.getComponent(), s.getComponent());
            }
            this.doInitializationMethod();
        }
        catch (Exception e) {
            this.initialisationErrorListener.error(e.getMessage(), e, LOG);
        }
    }

    private void doInitializationMethod() {
        try {
            ComponentInstance[] list;
            for (ComponentInstance si : list = this.components.values().toArray(new ComponentInstance[this.components.size()])) {
                this.doInitializationMethod(si);
            }
            Map<Class, ComponentInstance> removeList = this.components.entrySet().stream().filter(c -> !((ComponentInstance)c.getValue()).isSingleton() && !((ComponentInstance)c.getValue()).hasInitializationMethod()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            if (!removeList.isEmpty()) {
                for (Map.Entry<Class, ComponentInstance> e : removeList.entrySet()) {
                    LOG.fine("Remove no Singleton Component " + String.valueOf(e.getKey()));
                    this.components.remove(e.getKey());
                }
            }
        }
        catch (Exception e) {
            this.initialisationErrorListener.error(e.getMessage(), e, LOG);
        }
    }

    private void doInitializationMethod(ComponentInstance si) {
        try {
            if (si.hasInitializationMethod()) {
                boolean dooInit = true;
                for (Field f : si.getInjectedFields()) {
                    f.setAccessible(true);
                    if (f.get(si.getComponent()) != null) continue;
                    dooInit = false;
                }
                if (dooInit) {
                    long time = System.currentTimeMillis();
                    LOG.fine(String.valueOf(si.getComponent().getClass()) + " Call Method " + si.getInitializationMethod().getName());
                    si.getInitializationMethod().setAccessible(true);
                    Method init = si.getInitializationMethod();
                    si.initializationIsDone();
                    init.invoke(si.getComponent(), new Object[0]);
                    LOG.info(String.valueOf(si.getComponent().getClass()) + " auto init is done. (TIME:" + (System.currentTimeMillis() - time) + ")");
                }
            }
        }
        catch (Exception e) {
            this.initialisationErrorListener.error(e.getMessage(), e, LOG);
        }
    }

    private void injectLater(Object singleton) {
        try {
            ArrayList<InjectLaterObject> deleteList = new ArrayList<InjectLaterObject>();
            for (InjectLaterObject o : this.laterInjectStack) {
                if (o.field.getType() != singleton.getClass()) continue;
                try {
                    o.field.setAccessible(true);
                    o.field.set(o.instance, singleton);
                    deleteList.add(o);
                }
                catch (Exception e) {
                    this.initialisationErrorListener.error("Cant Inject later in Class " + o.instance.getClass().getName() + " at Field " + o.field.getName() + " inject Instance of " + String.valueOf(singleton.getClass()), e, LOG);
                }
            }
            if (!deleteList.isEmpty()) {
                this.laterInjectStack.removeAll(deleteList);
            }
        }
        catch (Exception e) {
            this.initialisationErrorListener.error(e.getMessage(), e, LOG);
        }
        LOG.fine("Inject Later Size is " + this.laterInjectStack.size());
    }

    public static void reset(InitialisationErrorListener listener) {
        instance = new Container();
        Container.instance.initialisationErrorListener = listener;
    }

    public static void createSingletons() throws Exception {
        Container.add(ReentrantLock.class);
        new CreateSingletons().create();
    }

    public static void add(Class clazz) {
        ComponentInstance component = new ComponentFactory().create(clazz);
        instance.addInternal(component);
    }

    public static <T> T add(T component) {
        ComponentInstance c = new ComponentFactory().create(component);
        instance.addInternal(c);
        LOG.fine("Inject Later Size is " + Container.instance.laterInjectStack.size());
        return component;
    }

    public static <T> T get(Class<T> type) {
        ComponentInstance ci = Container.instance.components.get(type);
        if (ci != null && ci.isSingleton()) {
            return type.cast(ci.getComponent());
        }
        throw new RuntimeException("Get a non Singleton Instance from Container. This is not a allowed operation. Can only call get(Class<T> type) Methode from Container for Singleton instance. Check the @Component Annotation...");
    }

    public static void addAndInject(Object instance) {
        Container.add(instance);
        Container.inject(instance);
    }

    public static void addAndInject(Class clazz) {
        Container.add(clazz);
        Object o = Container.get(clazz);
        Container.inject(o);
    }

    public static void inject(Object instance) {
        ComponentInstance ci = Container.instance.components.get(instance.getClass());
        if (ci == null) {
            ci = new ComponentFactory().create(instance);
        }
        Container.instance.inject(ci);
    }

    static class InjectLaterObject {
        private Object instance;
        private Field field;

        private InjectLaterObject(Object instance, Field field) {
            this.instance = instance;
            this.field = field;
        }
    }
}

