/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.singleton;

import de.mallongigi.singleton.Inject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

final class ComponentInstance {
    private static final Logger LOG = Logger.getLogger(ComponentInstance.class.getName());
    private Object component;
    private Method initializationMethod;
    private boolean singleton;

    ComponentInstance(Object component, Method initializationMethod, boolean singleton) {
        this.component = component;
        this.initializationMethod = initializationMethod;
        this.singleton = singleton;
        LOG.info("Create new Component Instance with " + component.getClass().getName() + ". Singleton is " + singleton + ". Initialization Methode is " + String.valueOf(initializationMethod));
    }

    void initializationIsDone() {
        this.initializationMethod = null;
    }

    boolean hasInitializationMethod() {
        return this.initializationMethod != null;
    }

    boolean isSingleton() {
        return this.singleton;
    }

    Object getComponent() {
        return this.component;
    }

    Method getInitializationMethod() {
        return this.initializationMethod;
    }

    public String toString() {
        return this.component.toString();
    }

    public int hashCode() {
        if (this.singleton) {
            return this.component.hashCode();
        }
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (this.singleton) {
            return this.component.equals(obj);
        }
        return super.equals(obj);
    }

    Field[] getInjectedFields() {
        ArrayList<Field> result = new ArrayList<Field>();
        result.addAll(this.filterFields(this.component.getClass().getDeclaredFields()));
        for (Class<?> superclass = this.component.getClass().getSuperclass(); superclass != null && !superclass.getName().startsWith("java"); superclass = superclass.getSuperclass()) {
            result.addAll(this.filterFields(superclass.getDeclaredFields()));
        }
        return result.toArray(new Field[result.size()]);
    }

    private List<Field> filterFields(Field[] fields) {
        ArrayList<Field> result = new ArrayList<Field>();
        for (Field f : fields) {
            if (f.getAnnotation(Inject.class) == null) continue;
            result.add(f);
        }
        return result;
    }
}

