/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.settings.model;

import de.mallongigi.podcast.channel.navigation.PodcastChannelModel;
import de.mallongigi.singleton.Singleton;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleStringProperty;

@Singleton(makeAutoInstance=false)
public final class ApplicationSettings {
    private static final Logger LOG = Logger.getLogger(ApplicationSettings.class.getName());
    private List<PodcastChannelModel> channels = new ArrayList<PodcastChannelModel>();
    private double applicationWidth;
    private double applicationHeight;
    private double spitPaneNavigationWidth = 0.4;
    private SimpleStringProperty converterPath = new SimpleStringProperty();
    private SimpleIntegerProperty automaticRefreshTimer = new SimpleIntegerProperty(15);
    private SimpleStringProperty usbStickPath = new SimpleStringProperty("");
    private boolean useInternalMediaPlayer = true;
    private Long registryNumber;
    private Long lastCleanTime = 0L;
    private Long podcastChannelIdCount = 0L;
    private Path lastSettingFile;

    public void add(PodcastChannelModel channel) {
        this.channels.add(channel);
    }

    public List<PodcastChannelModel> getChannels() {
        return this.channels;
    }

    public static Locale getLanguage() {
        return Locale.ENGLISH;
    }

    public double getApplicationWidth() {
        return this.applicationWidth;
    }

    public void setApplicationWidth(Double applicationWidth) {
        this.applicationWidth = applicationWidth;
    }

    public double getApplicationHeight() {
        return this.applicationHeight;
    }

    public void setApplicationHeight(Double applicationHeight) {
        this.applicationHeight = applicationHeight;
    }

    public double getSpitPaneNavigationWidth() {
        return this.spitPaneNavigationWidth;
    }

    public void setSpitPaneNavigationWidth(double spitPaneNavigationWidth) {
        this.spitPaneNavigationWidth = spitPaneNavigationWidth;
    }

    public void setFfmpegPath(String ffmpegPath) {
        if (ffmpegPath.length() > 0) {
            this.converterPath.setValue(ffmpegPath);
        }
    }

    public void setUsbPath(String usbPath) {
        if (usbPath == null) {
            return;
        }
        this.usbStickPath.setValue(usbPath);
    }

    public SimpleStringProperty getConverterPathProperty() {
        return this.converterPath;
    }

    public SimpleIntegerProperty getAutomaticRefreshTimerProperty() {
        return this.automaticRefreshTimer;
    }

    public SimpleStringProperty getUsbStickPathProperty() {
        return this.usbStickPath;
    }

    public void setAutomaticRefreshTimeInMinutes(String automaticRefreshTimeInMinutes) {
        this.setAutomaticRefreshTimeInMinutes(Integer.parseInt(automaticRefreshTimeInMinutes));
    }

    public void setAutomaticRefreshTimeInMinutes(Integer automaticRefreshTimeInMinutes) {
        if (automaticRefreshTimeInMinutes == null) {
            this.automaticRefreshTimer.set(15);
            return;
        }
        this.automaticRefreshTimer.set(automaticRefreshTimeInMinutes.intValue());
    }

    public boolean isUseInternalMediaPlayer() {
        return this.useInternalMediaPlayer;
    }

    public void setUseInternalMediaPlayer(boolean useInternalMediaPlayer) {
        this.useInternalMediaPlayer = useInternalMediaPlayer;
    }

    public Long getRegistryNumber() {
        if (this.registryNumber == null) {
            this.generateRegistryId();
        }
        return this.registryNumber;
    }

    private void generateRegistryId() {
        this.registryNumber = Math.abs(new Random().nextLong());
    }

    public void setRegistryNumber(Long registryNumber) {
        this.registryNumber = registryNumber;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String getVersion() {
        try (InputStream in = new ApplicationSettings().getClass().getResourceAsStream("/de/mallongigi/settings/version.txt");){
            String string;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, "utf-8"));){
                String line;
                string = line = reader.readLine();
            }
            return string;
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, e.getMessage(), e);
            return null;
        }
    }

    public void setLastCleanTime(Long lastCleanTime) {
        this.lastCleanTime = lastCleanTime;
    }

    public void setLastCleanTime(String lastCleanTime) {
        if (lastCleanTime == null) {
            return;
        }
        try {
            this.setLastCleanTime(Long.parseLong(lastCleanTime));
        }
        catch (Exception e) {
            LOG.log(Level.INFO, e.getMessage(), e);
        }
    }

    public Long getLastCleanTime() {
        return this.lastCleanTime;
    }

    public synchronized Long nextPodcastChannelIdCount() {
        Long l = this.podcastChannelIdCount;
        this.podcastChannelIdCount = this.podcastChannelIdCount + 1L;
        return this.podcastChannelIdCount;
    }

    public Long getPodcastChannelIdCount() {
        return this.podcastChannelIdCount;
    }

    public void setPodcastChannelIdCount(Long podcastChannelIdCount) {
        this.podcastChannelIdCount = podcastChannelIdCount;
    }

    public Path getLastSettingFile() {
        return this.lastSettingFile;
    }

    public void setLastSettingFile(Path lastSettingFile) {
        this.lastSettingFile = lastSettingFile;
    }

    public boolean isConverterAvailable() {
        String path = this.getConverterPathProperty().getValue();
        if (path == null || path.isBlank()) {
            return false;
        }
        return new File(path).exists();
    }
}

