/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.settings.json;

import de.mallongigi.dialog.ErrorDialog;
import de.mallongigi.file.FileUtil;
import de.mallongigi.mediaplayer.transcription.TranscriptionsLocations;
import de.mallongigi.podcast.channel.model.PodcastChannelContainer;
import de.mallongigi.podcast.channel.model.PodcastNavigationViewType;
import de.mallongigi.podcast.channel.navigation.PodcastChannelModel;
import de.mallongigi.podcast.episode.model.Chapter;
import de.mallongigi.podcast.episode.navigation.PodcastEpisodeModel;
import de.mallongigi.resource.language.LanguageKeys;
import de.mallongigi.settings.SettingFile;
import de.mallongigi.settings.model.ApplicationSettings;
import de.mallongigi.settings.model.SettingsParameter;
import de.mallongigi.singleton.Container;
import jakarta.json.Json;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public final class SaveSettings {
    private static final Logger LOG = Logger.getLogger(SaveSettings.class.getName());
    private final ApplicationSettings applicationSettings;
    private double applicationWidth;
    private double applicationHeight;

    public SaveSettings(ApplicationSettings settings) {
        Container.inject(this);
        this.applicationSettings = settings;
    }

    public void setApplicationWidth(double applicationWidth) {
        this.applicationWidth = applicationWidth;
    }

    public void setApplicationHeight(double applicationHeight) {
        this.applicationHeight = applicationHeight;
    }

    public Boolean execute() {
        Boolean bl;
        Path file = SettingFile.getSettingFile(FileUtil.FileType.zip);
        LOG.info(String.format("Setting file write to %s", file));
        FileOutputStream fos = new FileOutputStream(file.toFile());
        try {
            ZipOutputStream zipOut = new ZipOutputStream(fos);
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)zipOut, StandardCharsets.UTF_8));
            zipOut.putNextEntry(new ZipEntry("settings.json"));
            zipOut.write(this.createSettingsFileContent().toString().getBytes());
            writer.flush();
            zipOut.closeEntry();
            zipOut.putNextEntry(new ZipEntry("version.txt"));
            this.createVersionFileContent().store(writer, null);
            writer.flush();
            zipOut.closeEntry();
            for (PodcastChannelModel pcm : Container.get(PodcastChannelContainer.class).getPodcastChannels(PodcastNavigationViewType.Podcast)) {
                zipOut.putNextEntry(new ZipEntry(pcm.getId() + ".json"));
                this.writePodcastChannel(pcm, writer);
                zipOut.closeEntry();
            }
            zipOut.close();
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    fos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                new ErrorDialog().show(LanguageKeys.errorMessageSaveSettings, (Throwable)e);
                return false;
            }
        }
        fos.close();
        return bl;
    }

    private Properties createVersionFileContent() {
        Properties settings = new Properties();
        settings.setProperty(SettingsParameter.settingVersion.name(), "3");
        return settings;
    }

    private JsonObject createSettingsFileContent() {
        JsonObjectBuilder settings = Json.createObjectBuilder();
        settings.add(SettingsParameter.lastClearTime.name(), this.applicationSettings.getLastCleanTime().longValue());
        settings.add(SettingsParameter.applicationWidth.name(), this.applicationWidth);
        settings.add(SettingsParameter.applicationHeight.name(), this.applicationHeight);
        settings.add(SettingsParameter.spitPaneNavigationWidth.name(), this.applicationSettings.getSpitPaneNavigationWidth());
        settings.add(SettingsParameter.ffMpegPath.name(), this.applicationSettings.getConverterPathProperty().getValue());
        settings.add(SettingsParameter.automaticRefreshTimeInMinutes.name(), this.applicationSettings.getAutomaticRefreshTimerProperty().getValue().intValue());
        settings.add(SettingsParameter.usbStickPath.name(), this.applicationSettings.getUsbStickPathProperty().getValue());
        settings.add(SettingsParameter.internalMediaPlayer.name(), this.applicationSettings.isUseInternalMediaPlayer());
        settings.add(SettingsParameter.registryNumber.name(), this.applicationSettings.getRegistryNumber().longValue());
        settings.add(SettingsParameter.runEpisodeFileNameConverter.name(), false);
        return settings.build();
    }

    private void writePodcastChannel(PodcastChannelModel channel, BufferedWriter writer) throws IOException {
        JSONSettings settings = new JSONSettings(this, Json.createObjectBuilder());
        settings.add(SettingsParameter.id, channel.getId());
        settings.add(SettingsParameter.description, channel.getDescription());
        settings.add(SettingsParameter.homepage, channel.getHomepage());
        settings.addPath(SettingsParameter.localDirectory, channel.getLocaleDirectory());
        settings.add(SettingsParameter.remoteImageUrl, channel.getImageURL());
        settings.add(SettingsParameter.title, channel.getTitle());
        settings.add(SettingsParameter.podcastFeedUrl, channel.getPodcastFeedUrl());
        settings.add(SettingsParameter.cashHash, channel.getCachHash());
        settings.add(SettingsParameter.usbStickPath, channel.getUsbPath());
        settings.add(SettingsParameter.automaticDownload, channel.isAutomaticDownload());
        settings.add(SettingsParameter.podcastFeedTechnicalType, channel.getFeedType().name());
        JsonArrayBuilder episodeList = Json.createArrayBuilder();
        for (PodcastEpisodeModel im : channel.getEpisodes()) {
            StringBuffer shownotes;
            JSONSettings episode = new JSONSettings(this, Json.createObjectBuilder());
            if (im.getState().isNew() && !im.getState().isPresent()) {
                episode.add(SettingsParameter.waitForManuelDownload, true);
            }
            episode.add(SettingsParameter.description, im.getDescription());
            episode.add(SettingsParameter.duration, im.getDuration());
            episode.add(SettingsParameter.id, im.getId());
            episode.add(SettingsParameter.image, im.getImageURL());
            episode.add(SettingsParameter.length, im.getLength());
            episode.add(SettingsParameter.link, im.getLink());
            episode.add(SettingsParameter.subtitle, im.getSubtitle());
            episode.add(SettingsParameter.title, im.getTitle());
            episode.add(SettingsParameter.type, im.getMediaType());
            episode.add(SettingsParameter.url, im.getUrl());
            episode.add(SettingsParameter.date, im.getDate().getTime());
            episode.add(SettingsParameter.played, im.getState().isPlayed());
            episode.add(SettingsParameter.downloaded, im.isDownloaded());
            episode.add(SettingsParameter.playerDuration, im.getPlayerDuration());
            if (im.getState().isPresent() && (shownotes = im.getShownotes()) != null) {
                episode.add(SettingsParameter.shownotes, shownotes.toString());
            }
            if (im.hasChapters()) {
                JsonArrayBuilder chaptersList = Json.createArrayBuilder();
                for (Chapter chapter : im.getChapters()) {
                    JSONSettings chapterNode = new JSONSettings(this, Json.createObjectBuilder());
                    chapterNode.add(SettingsParameter.chapter_start_time, String.valueOf(chapter.getStartTime()));
                    chapterNode.add(SettingsParameter.chapter_title, chapter.getTitle());
                    chapterNode.add(SettingsParameter.chapter_link, chapter.getLink());
                    chapterNode.add(SettingsParameter.chapter_image, chapter.getImageURL());
                    chaptersList.add(chapterNode.job);
                }
                episode.add(SettingsParameter.chapters, chaptersList);
            }
            if (im.hasTranscriptions()) {
                JsonArrayBuilder transcriptionList = Json.createArrayBuilder();
                for (TranscriptionsLocations l : im.getTranscriptions()) {
                    JSONSettings locationNode = new JSONSettings(this, Json.createObjectBuilder());
                    locationNode.add(SettingsParameter.transcription_type, String.valueOf((Object)l.type()));
                    locationNode.add(SettingsParameter.transcription_url, l.url());
                    transcriptionList.add(locationNode.job);
                }
                episode.add(SettingsParameter.transcription, transcriptionList);
            }
            episodeList.add(episode.job);
        }
        settings.add(SettingsParameter.episodeList, episodeList);
        writer.write(settings.toString());
        writer.flush();
    }

    private class JSONSettings {
        JsonObjectBuilder job;

        private JSONSettings(SaveSettings saveSettings, JsonObjectBuilder job) {
            this.job = job;
        }

        private void add(SettingsParameter parameter, String value) {
            if (value == null) {
                return;
            }
            this.job.add(parameter.name(), value);
        }

        private void add(SettingsParameter parameter, Double value) {
            if (value == null) {
                return;
            }
            this.job.add(parameter.name(), value.doubleValue());
        }

        private void add(SettingsParameter parameter, Long value) {
            if (value == null) {
                return;
            }
            this.job.add(parameter.name(), value.longValue());
        }

        private void add(SettingsParameter parameter, JsonArrayBuilder array) {
            if (array == null) {
                return;
            }
            this.job.add(parameter.name(), array);
        }

        private void add(SettingsParameter parameter, Boolean value) {
            if (value == null) {
                return;
            }
            this.job.add(parameter.name(), value.booleanValue());
        }

        private void addPath(SettingsParameter parameter, String path) {
            if (path == null) {
                return;
            }
            try {
                Path relativPath = FileUtil.getPodcastHomeDirectory().relativize(Paths.get(path, new String[0]));
                this.add(parameter, relativPath.toString());
            }
            catch (Exception e) {
                LOG.log(Level.INFO, path, e);
                this.add(parameter, path);
            }
        }

        public String toString() {
            return this.job.build().toString();
        }
    }
}

