/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.settings.json;

import de.mallongigi.errorhandling.ErrorContainer;
import de.mallongigi.file.FileUtil;
import de.mallongigi.images.PixelImageLoader;
import de.mallongigi.images.model.ImageModelFactory;
import de.mallongigi.mediaplayer.transcription.TranscriptionTypes;
import de.mallongigi.mediaplayer.transcription.TranscriptionsLocations;
import de.mallongigi.platform.OSPlatform;
import de.mallongigi.podcast.channel.model.PodcastChannelFeedType;
import de.mallongigi.podcast.channel.navigation.PodcastChannelModel;
import de.mallongigi.podcast.episode.model.Chapter;
import de.mallongigi.podcast.episode.navigation.PodcastEpisodeModel;
import de.mallongigi.resource.language.LanguageKeys;
import de.mallongigi.settings.LoadSettingsInterface;
import de.mallongigi.settings.RegistryNumberGenerator;
import de.mallongigi.settings.json.SettingItem;
import de.mallongigi.settings.model.ApplicationSettings;
import de.mallongigi.settings.model.SettingsParameter;
import de.mallongigi.singleton.Container;
import de.mallongigi.singleton.Inject;
import de.mallongigi.start.preload.PreLoadTaskInterface;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public final class JSONSettingLoader
implements LoadSettingsInterface {
    private static final Logger LOG = Logger.getLogger(JSONSettingLoader.class.getName());
    @Inject
    private ErrorContainer errorContainer;
    @Inject
    private OSPlatform plattform;
    @Inject
    private ImageModelFactory imageModelFactory;
    private final PixelImageLoader imageLoader;
    private final PreLoadTaskInterface task;
    private ApplicationSettings result = new ApplicationSettings();
    private long maxProgress = 0L;
    private long progress = 0L;

    public JSONSettingLoader(PreLoadTaskInterface task) {
        this.task = task;
        Container.inject(this);
        this.imageLoader = new PixelImageLoader();
    }

    @Override
    public void load(Path file) throws Exception {
        ExecutorService executor = Executors.newFixedThreadPool(2);
        ZipFile zipFile = new ZipFile(file.toFile());
        try {
            this.parseMainWindow(new InputStreamReader(zipFile.getInputStream(zipFile.getEntry("settings.json")), StandardCharsets.UTF_8));
            this.maxProgress = zipFile.size();
            Enumeration<? extends ZipEntry> list = zipFile.entries();
            block12: while (list.hasMoreElements()) {
                ZipEntry entry = list.nextElement();
                switch (entry.getName()) {
                    case "version.txt": 
                    case "settings.json": {
                        continue block12;
                    }
                }
                JsonReader jsonReader = Json.createReader((Reader)new InputStreamReader(zipFile.getInputStream(entry), StandardCharsets.UTF_8));
                executor.execute(this.parseChannel(jsonReader));
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            executor.shutdown();
            executor.awaitTermination(1L, TimeUnit.MINUTES);
            zipFile.close();
        }
    }

    private void parseMainWindow(InputStreamReader in) {
        try {
            JsonReader jsonReader = Json.createReader((Reader)in);
            SettingItem settings = new SettingItem(jsonReader.readObject());
            this.result.setPodcastChannelIdCount(settings.get(SettingsParameter.podcastChannelIdCount, 1L));
            this.result.setLastCleanTime(settings.get(SettingsParameter.lastClearTime, 0L));
            this.result.setRegistryNumber(settings.get(SettingsParameter.registryNumber, RegistryNumberGenerator.createNumber()));
            this.result.setApplicationWidth(settings.get(SettingsParameter.applicationWidth, 800.0));
            this.result.setApplicationHeight(settings.get(SettingsParameter.applicationHeight, 800.0));
            this.result.setSpitPaneNavigationWidth(settings.get(SettingsParameter.spitPaneNavigationWidth, 0.3));
            this.result.setFfmpegPath(settings.get(SettingsParameter.ffMpegPath, ""));
            this.result.setAutomaticRefreshTimeInMinutes(settings.get(SettingsParameter.automaticRefreshTimeInMinutes, 15));
            this.result.setUsbPath(settings.get(SettingsParameter.usbStickPath));
            this.result.setUseInternalMediaPlayer(settings.getBoolean(SettingsParameter.internalMediaPlayer));
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    private Runnable parseChannel(final JsonReader jsonReader) {
        return new Runnable(){

            @Override
            public void run() {
                SettingItem settings = new SettingItem(jsonReader.readObject());
                PodcastChannelModel channel = new PodcastChannelModel();
                channel.setTitle(settings.get(SettingsParameter.title));
                JSONSettingLoader.this.task.update(channel.getTitle());
                channel.setId(settings.getLong(SettingsParameter.id));
                if (channel.getId() > JSONSettingLoader.this.result.getPodcastChannelIdCount()) {
                    JSONSettingLoader.this.result.setPodcastChannelIdCount(channel.getId());
                }
                channel.setDescription(settings.get(SettingsParameter.description));
                channel.setHomepage(settings.get(SettingsParameter.homepage));
                channel.setLocaleDirectory(JSONSettingLoader.this.clearPath(settings.get(SettingsParameter.localDirectory)));
                channel.setImageURL(settings.get(SettingsParameter.remoteImageUrl));
                channel.setPodcastFeedUrl(settings.get(SettingsParameter.podcastFeedUrl));
                channel.setCachHash(settings.get(SettingsParameter.cashHash));
                channel.setUsbPath(settings.get(SettingsParameter.usbStickPath));
                channel.setAutomaticDownload(settings.get(SettingsParameter.automaticDownload, true));
                channel.setImage(JSONSettingLoader.this.imageModelFactory.create(channel));
                JSONSettingLoader.this.imageLoader.create(channel.getImage(), 48);
                if (!settings.hasProperty(SettingsParameter.podcastFeedTechnicalType)) {
                    channel.setFeedType(PodcastChannelFeedType.RSS);
                } else {
                    String feedType = settings.get(SettingsParameter.podcastFeedTechnicalType);
                    if (feedType.equals(PodcastChannelFeedType.Audiothek.name())) {
                        channel.setFeedType(PodcastChannelFeedType.Audiothek);
                    } else {
                        channel.setFeedType(PodcastChannelFeedType.RSS);
                    }
                }
                JsonArray episodeList = settings.getArray(SettingsParameter.episodeList);
                episodeList.forEach(v -> {
                    try {
                        JsonArray chapters;
                        SettingItem e = new SettingItem(v.asJsonObject());
                        PodcastEpisodeModel im = new PodcastEpisodeModel();
                        im.setDescription(e.get(SettingsParameter.description));
                        im.setDuration(e.get(SettingsParameter.duration));
                        im.setId(e.get(SettingsParameter.id));
                        im.setImageURL(e.get(SettingsParameter.image));
                        im.setLength(e.get(SettingsParameter.length));
                        im.setLink(e.get(SettingsParameter.link));
                        im.setSubtitle(e.get(SettingsParameter.subtitle));
                        im.setTitle(e.get(SettingsParameter.title));
                        im.setMediaType(e.get(SettingsParameter.type));
                        im.setUrl(e.get(SettingsParameter.url));
                        im.setDownloaded(e.getBoolean(SettingsParameter.downloaded));
                        im.setChannel(channel);
                        im.setPlayerDuration(e.get(SettingsParameter.playerDuration, 0.0));
                        if (e.hasProperty(SettingsParameter.shownotes)) {
                            im.setShownotes(e.get(SettingsParameter.shownotes));
                        }
                        if (e.hasProperty(SettingsParameter.waitForManuelDownload)) {
                            im.setWaitForManuelDownload(e.getBoolean(SettingsParameter.waitForManuelDownload));
                            im.getState().setNew(true);
                        } else {
                            im.getState().setNew(false);
                        }
                        if (e.hasProperty(SettingsParameter.chapters)) {
                            chapters = e.getArray(SettingsParameter.chapters);
                            chapters.forEach(cn -> {
                                try {
                                    SettingItem chapterItem = new SettingItem(cn.asJsonObject());
                                    Chapter c = new Chapter(Long.parseLong(chapterItem.get(SettingsParameter.chapter_start_time))).setImageURL(chapterItem.get(SettingsParameter.chapter_image)).setLink(chapterItem.get(SettingsParameter.chapter_link)).setTitle(chapterItem.get(SettingsParameter.chapter_title));
                                    im.addChapter(c);
                                }
                                catch (Exception ce) {
                                    LOG.log(Level.INFO, ce.getMessage(), ce);
                                }
                            });
                        }
                        if (e.hasProperty(SettingsParameter.transcription)) {
                            chapters = e.getArray(SettingsParameter.transcription);
                            chapters.forEach(cn -> {
                                try {
                                    String type;
                                    SettingItem item = new SettingItem(cn.asJsonObject());
                                    switch (type = item.get(SettingsParameter.transcription_type)) {
                                        case "JSON": {
                                            im.addTranscription(new TranscriptionsLocations(TranscriptionTypes.JSON, item.get(SettingsParameter.transcription_url)));
                                            break;
                                        }
                                        case "VTT": {
                                            im.addTranscription(new TranscriptionsLocations(TranscriptionTypes.VTT, item.get(SettingsParameter.transcription_url)));
                                        }
                                    }
                                }
                                catch (Exception ce) {
                                    LOG.log(Level.INFO, ce.getMessage(), ce);
                                }
                            });
                        }
                        im.setDate(e.get(SettingsParameter.date, JSONSettingLoader.this.plattform.getSystemDate()));
                        im.getState().setPlayed(e.getBoolean(SettingsParameter.played));
                        if (im.getUrl() != null && im.getUrl().length() > 0) {
                            boolean isPresent = Files.exists(channel.getPodcastFilenameConverter().convertEpisode(im), new LinkOption[0]);
                            im.getState().setPresent(isPresent);
                        } else {
                            im.getState().setPresent(false);
                        }
                        im.setImage(JSONSettingLoader.this.imageModelFactory.create(im));
                        channel.add(im);
                    }
                    catch (Exception e) {
                        LOG.log(Level.INFO, JSONSettingLoader.this.errorContainer.add(LanguageKeys.errorReadItemSetting, channel.getTitle()), e);
                    }
                });
                ++JSONSettingLoader.this.progress;
                JSONSettingLoader.this.task.update(JSONSettingLoader.this.progress, JSONSettingLoader.this.maxProgress);
                JSONSettingLoader.this.result.add(channel);
            }
        };
    }

    @Override
    public ApplicationSettings getResult() {
        return this.result;
    }

    private String clearPath(String path) {
        if (path == null) {
            return null;
        }
        if (Files.exists(Paths.get(path, new String[0]), new LinkOption[0])) {
            return path;
        }
        if (path.indexOf(File.separator) == -1 && path.indexOf("\\") != -1) {
            return FileUtil.getPodcastHomeDirectory().resolve(path.replace('\\', File.separatorChar)).toString();
        }
        return FileUtil.getPodcastHomeDirectory().resolve(path).toString();
    }
}

