/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.settings.compatible.properties;

import de.mallongigi.errorhandling.ErrorContainer;
import de.mallongigi.file.FileUtil;
import de.mallongigi.images.model.ImageModelFactory;
import de.mallongigi.podcast.channel.model.PodcastChannelFeedType;
import de.mallongigi.podcast.channel.navigation.PodcastChannelModel;
import de.mallongigi.podcast.episode.navigation.PodcastEpisodeModel;
import de.mallongigi.resource.language.LanguageKeys;
import de.mallongigi.settings.RegistryNumberGenerator;
import de.mallongigi.settings.compatible.properties.Settings;
import de.mallongigi.settings.model.ApplicationSettings;
import de.mallongigi.settings.model.SettingsParameter;
import de.mallongigi.singleton.Container;
import de.mallongigi.singleton.Inject;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class SettingsParser {
    private static final Logger LOG = Logger.getLogger(SettingsParser.class.getName());
    @Inject
    private ErrorContainer errorContainer;
    @Inject
    private ImageModelFactory imageModelFactory;
    private ApplicationSettings result;
    private boolean runFileNameCoverterProcess = false;

    SettingsParser(ApplicationSettings result) {
        Container.inject(this);
        this.result = result;
    }

    void parseMainWindow(StringBuffer buffer) {
        try {
            Settings settings = new Settings(buffer);
            if (settings.hasProperty(SettingsParameter.podcastChannelIdCount)) {
                this.result.setPodcastChannelIdCount(settings.getLong(SettingsParameter.podcastChannelIdCount));
            }
            this.result.setLastCleanTime(settings.get(SettingsParameter.lastClearTime));
            String registryNumber = settings.get(SettingsParameter.registryNumber);
            if (registryNumber == null) {
                this.result.setRegistryNumber(RegistryNumberGenerator.createNumber());
            } else {
                this.result.setRegistryNumber(Long.parseLong(registryNumber));
            }
            this.result.setApplicationWidth(settings.getDouble(SettingsParameter.applicationWidth, 800.0));
            this.result.setApplicationHeight(settings.getDouble(SettingsParameter.applicationHeight, 800.0));
            this.result.setSpitPaneNavigationWidth(settings.getDouble(SettingsParameter.spitPaneNavigationWidth, 0.3));
            this.result.setFfmpegPath(settings.get(SettingsParameter.ffMpegPath, ""));
            this.result.setAutomaticRefreshTimeInMinutes(settings.get(SettingsParameter.automaticRefreshTimeInMinutes));
            this.result.setUsbPath(settings.get(SettingsParameter.usbStickPath));
            this.result.setUseInternalMediaPlayer(settings.getBoolean(SettingsParameter.internalMediaPlayer));
            this.runFileNameCoverterProcess = this.getCompatibilityProperty(SettingsParameter.runEpisodeFileNameConverter, settings);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    PodcastChannelModel parseChannel(StringBuffer buffer) {
        try {
            Settings settings = new Settings(buffer);
            PodcastChannelModel channel = new PodcastChannelModel();
            if (settings.hasProperty(SettingsParameter.id)) {
                channel.setId(settings.getLong(SettingsParameter.id));
                if (channel.getId() > this.result.getPodcastChannelIdCount()) {
                    this.result.setPodcastChannelIdCount(channel.getId());
                }
            } else {
                channel.setId(this.result.nextPodcastChannelIdCount());
            }
            channel.setDescription(settings.get(SettingsParameter.description));
            channel.setHomepage(settings.get(SettingsParameter.homepage));
            channel.setLocaleDirectory(this.clearPath(settings.get(SettingsParameter.localDirectory)));
            channel.setImageURL(settings.get(SettingsParameter.remoteImageUrl));
            channel.setTitle(settings.get(SettingsParameter.title));
            channel.setPodcastFeedUrl(settings.get(SettingsParameter.podcastFeedUrl));
            channel.setImage(this.imageModelFactory.create(channel));
            channel.setCachHash(settings.get(SettingsParameter.cashHash));
            channel.setUsbPath(settings.get(SettingsParameter.usbStickPath));
            channel.setAutomaticDownload(settings.getBoolean(SettingsParameter.automaticDownload, true));
            if (!settings.hasProperty(SettingsParameter.podcastFeedTechnicalType)) {
                channel.setFeedType(PodcastChannelFeedType.RSS);
            } else {
                String feedType = settings.get(SettingsParameter.podcastFeedTechnicalType);
                if (feedType.equals(PodcastChannelFeedType.Audiothek.name())) {
                    channel.setFeedType(PodcastChannelFeedType.Audiothek);
                } else {
                    channel.setFeedType(PodcastChannelFeedType.RSS);
                }
            }
            return channel;
        }
        catch (Exception e) {
            LOG.log(Level.INFO, this.errorContainer.add(LanguageKeys.errorMessageParseChannel, buffer), e);
            return null;
        }
    }

    PodcastEpisodeModel parseChannelItem(StringBuffer buffer, PodcastChannelModel channel) {
        try {
            Settings settings = new Settings(buffer);
            PodcastEpisodeModel im = new PodcastEpisodeModel();
            im.setDescription(settings.get(SettingsParameter.description));
            im.setDuration(settings.get(SettingsParameter.duration));
            im.setId(settings.get(SettingsParameter.id, im.getId()));
            im.setImageURL(settings.get(SettingsParameter.image));
            im.setLength(settings.get(SettingsParameter.length));
            im.setLink(settings.get(SettingsParameter.link));
            im.setSubtitle(settings.get(SettingsParameter.subtitle));
            im.setTitle(settings.get(SettingsParameter.title));
            im.setMediaType(settings.get(SettingsParameter.type));
            im.setUrl(settings.get(SettingsParameter.url));
            im.setDownloaded(settings.getBoolean(SettingsParameter.downloaded));
            im.setChannel(channel);
            im.setPlayerDuration(settings.getDouble(SettingsParameter.playerDuration));
            if (settings.hasProperty(SettingsParameter.shownotes)) {
                im.setShownotes(settings.get(SettingsParameter.shownotes));
            }
            if (settings.hasProperty(SettingsParameter.waitForManuelDownload)) {
                im.setWaitForManuelDownload(settings.getBoolean(SettingsParameter.waitForManuelDownload));
                im.getState().setNew(true);
            } else {
                im.getState().setNew(false);
            }
            im.setDate(settings.getDate(SettingsParameter.date));
            im.getState().setPlayed(settings.getBoolean(SettingsParameter.played));
            if (im.getUrl() != null && im.getUrl().length() > 0) {
                boolean isPresent = Files.exists(channel.getPodcastFilenameConverter().convertEpisode(im), new LinkOption[0]);
                im.getState().setPresent(isPresent);
            } else {
                im.getState().setPresent(false);
            }
            im.setImage(this.imageModelFactory.create(im));
            return im;
        }
        catch (Exception e) {
            LOG.log(Level.INFO, this.errorContainer.add(LanguageKeys.errorReadItemSetting, channel.getTitle()), e);
            return null;
        }
    }

    boolean isRunFileNameCoverterProcess() {
        return this.runFileNameCoverterProcess;
    }

    private boolean getCompatibilityProperty(SettingsParameter key, Settings settings) {
        if (!settings.hasProperty(key)) {
            return true;
        }
        return settings.getBoolean(key);
    }

    private String clearPath(String path) {
        if (path == null) {
            return null;
        }
        if (Files.exists(Paths.get(path, new String[0]), new LinkOption[0])) {
            return path;
        }
        if (path.indexOf(File.separator) == -1 && path.indexOf("\\") != -1) {
            return FileUtil.getPodcastHomeDirectory().resolve(path.replace('\\', File.separatorChar)).toString();
        }
        return FileUtil.getPodcastHomeDirectory().resolve(path).toString();
    }
}

