/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.settings.compatible;

import de.mallongigi.file.FileUtil;
import de.mallongigi.podcast.channel.navigation.PodcastChannelModel;
import de.mallongigi.podcast.episode.navigation.PodcastEpisodeModel;
import de.mallongigi.start.preload.PreLoadTaskInterface;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ConvertOldEpisodeFileNames {
    private static final Logger LOG = Logger.getLogger(ConvertOldEpisodeFileNames.class.getName());
    private List<PodcastChannelModel> channels;
    private PreLoadTaskInterface task;

    public ConvertOldEpisodeFileNames(List<PodcastChannelModel> channels, PreLoadTaskInterface task) {
        this.channels = channels;
        this.task = task;
    }

    public void convert() {
        int progress = 0;
        int max = this.channels.size();
        for (PodcastChannelModel channel : this.channels) {
            this.task.update(channel.getTitle());
            this.task.update(++progress, max);
            for (PodcastEpisodeModel e : channel.getEpisodes()) {
                try {
                    Path newFileName;
                    Path oldFileName = this.getOldEpisodeFileName(e);
                    if (!Files.exists(oldFileName, new LinkOption[0]) && !Files.exists(oldFileName = this.convertOldEpisodeFileNameTwo(e), new LinkOption[0]) || Files.exists(newFileName = channel.getPodcastFilenameConverter().convertEpisode(e), new LinkOption[0])) continue;
                    Files.move(oldFileName, newFileName, new CopyOption[0]);
                    e.getState().setPresent(true);
                }
                catch (Exception ex) {
                    LOG.log(Level.SEVERE, ex.getMessage(), ex);
                }
            }
        }
    }

    public Path getOldEpisodeFileName(PodcastEpisodeModel episode) throws IOException {
        String fileName = FileUtil.getFileNameFromUrl(episode.getUrl(), "mp3");
        Path downloadDir = FileUtil.getPodcastLocaleDownloadDirectory(episode.getChannel());
        Path file = FileSystems.getDefault().getPath(downloadDir.toString(), fileName);
        return file;
    }

    public Path convertOldEpisodeFileNameTwo(PodcastEpisodeModel episode) throws IOException {
        String url = episode.getUrl();
        Object fileName = FileUtil.getFileNameFromUrl(url, "mp3");
        fileName = Math.abs(url.substring(0, url.lastIndexOf("/")).hashCode()) + "_" + (String)fileName;
        Path downloadDir = FileUtil.getPodcastLocaleDownloadDirectory(episode.getChannel());
        Path file = FileSystems.getDefault().getPath(downloadDir.toString(), new String[]{fileName});
        return file;
    }
}

