/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.settings;

import de.mallongigi.file.FileUtil;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public final class SettingFile {
    SettingFile() {
    }

    public static final Path getSettingFile(FileUtil.FileType fileType) {
        String fileName = "settings";
        return switch (fileType) {
            case FileUtil.FileType.zip, FileUtil.FileType.txt -> FileUtil.getPodcastHomeDirectory().resolve(fileName + "." + fileType.name());
            default -> FileUtil.getPodcastHomeDirectory().resolve(fileName + "." + FileUtil.FileType.zip.name());
        };
    }

    static final FileUtil.FileType getCurrentSettingFileType() {
        if (Files.exists(SettingFile.getSettingFile(FileUtil.FileType.txt), new LinkOption[0])) {
            return FileUtil.FileType.txt;
        }
        return FileUtil.FileType.zip;
    }

    static final Path getSettingFile() {
        return SettingFile.getSettingFile(SettingFile.getCurrentSettingFileType());
    }

    static final boolean exsistsSettingFile() {
        return Files.exists(SettingFile.getSettingFile(FileUtil.FileType.zip), new LinkOption[0]) || Files.exists(SettingFile.getSettingFile(FileUtil.FileType.txt), new LinkOption[0]);
    }
}

