/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.settings;

import de.mallongigi.file.FileUtil;
import de.mallongigi.platform.OSPlatform;
import de.mallongigi.settings.SettingFile;
import de.mallongigi.singleton.Container;
import de.mallongigi.singleton.Inject;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class CopySettings {
    private static final Logger LOG = Logger.getLogger(CopySettings.class.getName());
    @Inject
    private OSPlatform plattform;

    public CopySettings() {
        Container.inject(this);
    }

    public Path execute() {
        try {
            Path settingDir = FileUtil.getPodcastHomeDirectory();
            List<Path> list = Files.list(settingDir).filter(f -> {
                String n = f.getFileName().toString().toLowerCase();
                return n.startsWith("settings.zip_") && n.endsWith(".zip");
            }).toList();
            if (list.size() > 9) {
                ArrayList<Path> sortList = new ArrayList<Path>();
                sortList.addAll(list);
                sortList.sort((p1, p2) -> {
                    try {
                        String f1 = p1.getFileName().toString();
                        String f2 = p2.getFileName().toString();
                        Long t1 = Long.parseLong(f1.substring(f1.indexOf("_") + 1, f1.lastIndexOf(".")));
                        Long t2 = Long.parseLong(f2.substring(f2.indexOf("_") + 1, f2.lastIndexOf(".")));
                        return t1.compareTo(t2);
                    }
                    catch (NumberFormatException e) {
                        throw new RuntimeException("Fehler beim Lesen der Datei-Attribute", e);
                    }
                });
                for (int i = 0; i < sortList.size() - 9; ++i) {
                    FileUtil.delete((Path)sortList.getFirst());
                }
            }
            FileUtil.FileType type = null;
            if (Files.exists(SettingFile.getSettingFile(FileUtil.FileType.zip), new LinkOption[0])) {
                type = FileUtil.FileType.zip;
            } else if (Files.exists(SettingFile.getSettingFile(FileUtil.FileType.txt), new LinkOption[0])) {
                type = FileUtil.FileType.txt;
            } else {
                return null;
            }
            Path target = Paths.get(SettingFile.getSettingFile(FileUtil.FileType.none).toString() + "_" + this.plattform.getSystemTime() + "." + type.name(), new String[0]);
            Files.copy(SettingFile.getSettingFile(), target, StandardCopyOption.COPY_ATTRIBUTES);
            return target;
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }
}

