/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.resource.language;

import de.mallongigi.resource.language.LanguageKeys;
import de.mallongigi.settings.model.ApplicationSettings;
import de.mallongigi.singleton.Initialization;
import de.mallongigi.singleton.Singleton;
import java.text.MessageFormat;
import java.util.ResourceBundle;

@Singleton
public final class LanguageResource {
    private ResourceBundle resourceBundle;

    private LanguageResource() {
    }

    @Initialization
    private void loadBundle() {
        this.resourceBundle = ResourceBundle.getBundle("de/mallongigi/language/labels", ApplicationSettings.getLanguage());
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public String messageForKey(LanguageKeys key) {
        return this.resourceBundle.getString(key.name());
    }

    public String messageForKey(LanguageKeys key, Object ... parameters) {
        return MessageFormat.format(this.resourceBundle.getString(key.name()), parameters);
    }
}

