/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.resource.icons;

import de.mallongigi.resource.icons.DefaultIcons;
import de.mallongigi.resource.icons.IconColors;
import de.mallongigi.singleton.Container;
import de.mallongigi.singleton.Inject;
import de.mallongigi.ui.style.Styles;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.scene.Node;
import javafx.scene.layout.Region;
import javafx.scene.shape.SVGPath;
import javafx.scene.shape.Shape;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

final class SVGLoader {
    private static final Logger LOG = Logger.getLogger(SVGLoader.class.getName());
    @Inject
    private Styles styles;

    SVGLoader() {
        Container.inject(this);
    }

    Region get(DefaultIcons svg, int size, IconColors color) {
        return this.get(svg.getLocation(), size, color);
    }

    private Region get(String location, int size, IconColors color) {
        try {
            SVGPath path = new SVGPath();
            path.setContent(this.readSVGPathString(location));
            Region r = new Region();
            r.setShape((Shape)path);
            r.setPrefSize((double)size, (double)size);
            r.setMinSize((double)size, (double)size);
            r.setMaxSize((double)size, (double)size);
            this.styles.setStyle((Node)r, color);
            return r;
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, e.getMessage(), e);
            return new Region();
        }
    }

    private String readSVGPathString(String location) throws Exception {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            Document doc = factory.newDocumentBuilder().parse(this.getClass().getResourceAsStream(location));
            NodeList list = doc.getElementsByTagName("path");
            if (list == null || list.getLength() != 1) {
                throw new Exception(location + " Wrong SVG File Format. Only SVG-Path File Format can read (https://www.w3schools.com/graphics/svg_path.asp).");
            }
            return ((Element)list.item(0)).getAttribute("d");
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, e.getMessage(), e);
            throw e;
        }
    }
}

