/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.podcast.ui;

import de.mallongigi.podcast.channel.navigation.PodcastChannelNavigation;
import de.mallongigi.podcast.episode.navigation.PodcastEpisodeList;
import de.mallongigi.podcast.progress.ProgressList;
import de.mallongigi.settings.model.ApplicationSettings;
import de.mallongigi.singleton.Component;
import de.mallongigi.singleton.Initialization;
import de.mallongigi.singleton.Inject;
import de.mallongigi.toolbar.ApplicationToolbar;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.SplitPane;
import javafx.scene.layout.BorderPane;

@Component
public final class PodcastPane
extends BorderPane {
    @Inject
    private ApplicationSettings settings;
    @Inject
    private PodcastEpisodeList episodenList;
    @Inject
    private ProgressList progressView;
    @Inject
    private ApplicationToolbar applicationToolbar;
    @Inject
    private PodcastChannelNavigation navigation;

    private PodcastPane() {
    }

    @Initialization
    private void init() {
        SplitPane mainSplitPane = new SplitPane();
        SplitPane progressSplitPane = new SplitPane();
        progressSplitPane.setOrientation(Orientation.VERTICAL);
        mainSplitPane.getItems().addAll((Object[])new Node[]{progressSplitPane, this.episodenList});
        progressSplitPane.getItems().addAll((Object[])new Node[]{this.navigation, this.progressView.getComponent()});
        SplitPane.setResizableWithParent((Node)this.navigation, (Boolean)Boolean.TRUE);
        SplitPane.setResizableWithParent((Node)progressSplitPane, (Boolean)Boolean.TRUE);
        mainSplitPane.setDividerPositions(new double[]{this.settings.getSpitPaneNavigationWidth()});
        progressSplitPane.setDividerPositions(new double[]{0.8, 0.2});
        this.setCenter((Node)mainSplitPane);
        this.setTop((Node)this.applicationToolbar);
        ((SplitPane.Divider)mainSplitPane.getDividers().getFirst()).positionProperty().addListener((o, oldValue, newValue) -> this.settings.setSpitPaneNavigationWidth(newValue.doubleValue()));
    }
}

