/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.podcast.search.itunes;

import de.mallongigi.podcast.search.itunes.ITunesClient;
import de.mallongigi.podcast.search.itunes.ITunesItem;
import java.util.logging.Logger;

public final class ITunesURLConverter {
    private static final Logger LOG = Logger.getLogger(ITunesURLConverter.class.getName());

    public String convert(String iTunesUrl) {
        try {
            String id;
            ITunesClient client;
            ITunesItem[] result;
            int start = iTunesUrl.lastIndexOf("/") + 3;
            int end = iTunesUrl.indexOf("?", start);
            if (end == -1) {
                end = iTunesUrl.length();
            }
            if ((result = (client = new ITunesClient()).get("https://itunes.apple.com/lookup?id=" + (id = iTunesUrl.substring(start, end)))) != null && result.length == 1) {
                return result[0].getFeedUrl();
            }
            return null;
        }
        catch (Exception e) {
            LOG.info(String.format("Cant convert iTunes URL \" %s \"", iTunesUrl));
            return null;
        }
    }
}

