/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.podcast.search.itunes;

import de.mallongigi.http.ByteOrderMarkets;
import de.mallongigi.http.HttpParameters;
import de.mallongigi.http.HttpResponseHeader;
import de.mallongigi.podcast.search.itunes.ITunesItem;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;

public final class ITunesClient {
    private static final Logger LOG = Logger.getLogger(ITunesClient.class.getName());

    public ITunesItem[] get(String url) throws Exception {
        LOG.info(String.format("Aufruf mit iTunesClient von %s ", url));
        HttpClient client = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.ALWAYS).build();
        HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().uri(URI.create(url)).header(HttpParameters.USER_AGENT.value(), "Mallongigi Podcatcher").header(HttpParameters.ACCEPT_ENCODING.value(), "gzip, deflate").version(HttpClient.Version.HTTP_1_1).GET().timeout(Duration.ofMinutes(1L));
        HttpRequest request = requestBuilder.build();
        HttpResponse<InputStream> response = client.send(request, HttpResponse.BodyHandlers.ofInputStream());
        if (response.statusCode() >= 400) {
            return null;
        }
        HttpResponseHeader headers = new HttpResponseHeader(response.headers());
        StringBuffer buffer = new StringBuffer();
        String encoding = headers.getContentEncoding();
        String charset = headers.getCharset();
        if (encoding != null && encoding.equals("gzip")) {
            in = new BufferedReader(new InputStreamReader((InputStream)new GZIPInputStream(response.body()), charset));
            try {
                if (charset.toLowerCase().equals("utf-8")) {
                    this.readUTF8(buffer, in);
                }
                this.read(buffer, in);
            }
            finally {
                in.close();
            }
        } else {
            in = new BufferedReader(new InputStreamReader(response.body(), charset));
            try {
                if (charset.toLowerCase().equals("utf-8")) {
                    this.readUTF8(buffer, in);
                } else {
                    this.read(buffer, in);
                }
            }
            finally {
                in.close();
            }
        }
        JsonObject jsonObject = Json.createReader((Reader)new StringReader(buffer.toString())).readObject();
        JsonArray values = jsonObject.getJsonArray("results");
        return this.parse(values);
    }

    private ITunesItem[] parse(JsonArray values) throws Exception {
        ArrayList<ITunesItem> result = new ArrayList<ITunesItem>();
        int size = values.size();
        for (int i = 0; i < size; ++i) {
            try {
                String feedUrl;
                JsonObject entry = values.getJsonObject(i);
                ITunesItem item = new ITunesItem();
                String type = this.getString(Parameter.kind, entry);
                if (type == null || !type.equalsIgnoreCase("podcast") || (feedUrl = this.getString(Parameter.feedUrl, entry)) == null) continue;
                item.setFeedUrl(feedUrl);
                item.setArtist(this.getString(Parameter.artistName, entry));
                item.setCountry(this.getString(Parameter.country, entry));
                item.setName(this.getString(Parameter.collectionName, entry));
                item.setImageUrl(this.getString(Parameter.artworkUrl100, entry));
                item.setHomepageUrl(this.getString(Parameter.collectionViewUrl, entry));
                item.setEpsiodeCount(this.getInteger(Parameter.trackCount, entry));
                entry.getJsonArray(Parameter.genres.name()).forEach(v -> item.addGenres(v.toString()));
                result.add(item);
                continue;
            }
            catch (Exception e) {
                LOG.log(Level.INFO, e.getMessage(), e);
            }
        }
        return result.toArray(new ITunesItem[result.size()]);
    }

    private Integer getInteger(Parameter p, JsonObject o) {
        JsonNumber value = o.getJsonNumber(p.name());
        if (value == null) {
            return null;
        }
        return value.intValue();
    }

    private String getString(Parameter p, JsonObject o) {
        JsonString value = o.getJsonString(p.name());
        if (value == null) {
            return null;
        }
        return value.getString();
    }

    private void readUTF8(StringBuffer buffer, BufferedReader in) throws IOException {
        String line;
        boolean firstLine = true;
        while ((line = in.readLine()) != null) {
            if (firstLine) {
                if (line.startsWith(ByteOrderMarkets.UTF8_BOM.value())) {
                    line = line.substring(1);
                }
                firstLine = false;
            }
            buffer.append(line + "\n");
        }
    }

    private void read(StringBuffer buffer, BufferedReader in) throws IOException {
        String line;
        while ((line = in.readLine()) != null) {
            buffer.append(line + "\n");
        }
    }

    private static enum Parameter {
        kind,
        artistName,
        collectionName,
        collectionViewUrl,
        feedUrl,
        artworkUrl100,
        country,
        genres,
        trackCount;

    }
}

