/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.podcast.search;

import de.mallongigi.podcast.search.PodcastSearchPane;
import de.mallongigi.podcast.search.itunes.ITunesClient;
import de.mallongigi.podcast.search.itunes.ITunesItem;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.concurrent.Service;
import javafx.concurrent.Task;

final class SearchService
extends Service<ITunesItem[]> {
    private static final Logger LOG = Logger.getLogger(SearchService.class.getName());
    private final PodcastSearchPane gui;
    private String query;

    SearchService(PodcastSearchPane gui) {
        this.gui = gui;
    }

    void setQuery(String query) {
        this.query = query;
    }

    protected Task<ITunesItem[]> createTask() {
        return new Task<ITunesItem[]>(){

            protected ITunesItem[] call() {
                try {
                    if (SearchService.this.query.length() < 3) {
                        return null;
                    }
                    ITunesItem[] items = new ITunesClient().get("https://itunes.apple.com/search?media=podcast&term=" + SearchService.this.query.trim().replace(" ", "+"));
                    if (items == null) {
                        return null;
                    }
                    return items;
                }
                catch (Exception e) {
                    LOG.log(Level.INFO, e.getMessage(), e);
                    return null;
                }
            }
        };
    }

    protected void succeeded() {
        this.gui.setResult((ITunesItem[])this.getValue());
        super.succeeded();
    }

    protected void failed() {
        this.gui.noResult();
        super.failed();
    }
}

