/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.podcast.progress;

import de.mallongigi.images.elements.UIImageFactory;
import de.mallongigi.podcast.model.Model;
import de.mallongigi.podcast.progress.AbstractProgressHandler;
import de.mallongigi.podcast.progress.ProgressAction;
import de.mallongigi.podcast.progress.ProgressModel;
import de.mallongigi.resource.icons.DefaultIcons;
import de.mallongigi.resource.icons.IconColors;
import de.mallongigi.resource.icons.IconFactory;
import de.mallongigi.singleton.Initialization;
import de.mallongigi.singleton.Inject;
import de.mallongigi.singleton.Singleton;
import de.mallongigi.toolbar.ApplicationToolbarModel;
import de.mallongigi.ui.concurrent.JavaFXUtil;
import de.mallongigi.ui.style.BasicCssClasses;
import de.mallongigi.ui.style.Styles;
import java.text.DecimalFormat;
import java.util.List;
import java.util.function.Predicate;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.transformation.FilteredList;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.util.Callback;

@Singleton
public final class ProgressList {
    private ListView<AbstractProgressHandler<? extends Model>> listView;
    @Inject
    private ApplicationToolbarModel toolbarModel;
    @Inject
    private UIImageFactory imageComponentFactory;
    @Inject
    private IconFactory iconFactory;
    @Inject
    private Styles background;

    @Initialization
    private void init() {
        this.listView = new ListView();
        this.listView.setSelectionModel(null);
        this.listView.setCellFactory((Callback)new ProgressListCellFactory());
    }

    void remove(AbstractProgressHandler<? extends Model> item) {
        this.listView.getItems().remove(item);
        if (this.listView.getItems().isEmpty()) {
            this.toolbarModel.setProgressMode(false);
        }
    }

    void add(AbstractProgressHandler<? extends Model> item) {
        if (this.listView.getItems().contains(item)) {
            return;
        }
        this.listView.getItems().add(item);
        this.toolbarModel.setProgressMode(true);
    }

    boolean contains(AbstractProgressHandler<? extends Model> handler) {
        return this.listView.getItems().contains(handler);
    }

    public int size(final ProgressAction action) {
        FilteredList list = this.listView.getItems().filtered((Predicate)new Predicate<AbstractProgressHandler<? extends Model>>(){

            @Override
            public boolean test(AbstractProgressHandler<? extends Model> t) {
                return t.getActionType() == action;
            }
        });
        return list.size();
    }

    List<AbstractProgressHandler<? extends Model>> items() {
        return this.listView.getItems();
    }

    public ListView<AbstractProgressHandler<? extends Model>> getComponent() {
        return this.listView;
    }

    private class ProgressListCellFactory
    implements Callback<ListView<AbstractProgressHandler<? extends Model>>, ListCell<AbstractProgressHandler<? extends Model>>> {
        private ProgressListCellFactory() {
        }

        public ListCell<AbstractProgressHandler<? extends Model>> call(ListView<AbstractProgressHandler<? extends Model>> param) {
            return new ListCell<AbstractProgressHandler<? extends Model>>(){

                protected void updateItem(AbstractProgressHandler<? extends Model> handler, boolean empty) {
                    super.updateItem(handler, empty);
                    if (empty) {
                        this.setGraphic(null);
                    } else {
                        this.setGraphic((Node)ProgressListCellFactory.this.createItemComponent(handler));
                    }
                }
            };
        }

        private BorderPane createItemComponent(final AbstractProgressHandler<? extends Model> handler) {
            final BorderPane root = new BorderPane();
            root.prefWidthProperty().bind((ObservableValue)ProgressList.this.listView.widthProperty().subtract(30));
            root.setMaxWidth(Double.NEGATIVE_INFINITY);
            root.setMinHeight(48.0);
            ProgressModel<? extends Model> model = handler.getProgressModel();
            Label label = new Label();
            label.textProperty().bind((ObservableValue)model.getTitleProperty());
            label.setWrapText(true);
            label.setPadding(new Insets(0.0, 5.0, 0.0, 5.0));
            label.setMaxHeight(48.0);
            final Label progressState = new Label("000%");
            Group imageView = ProgressList.this.imageComponentFactory.create(model.getImage(), 48);
            GridPane centerWrapper = new GridPane();
            centerWrapper.setAlignment(Pos.CENTER_LEFT);
            if (handler.canCancel()) {
                Node image = ProgressList.this.iconFactory.create(DefaultIcons.Cancel, 32, IconColors.Error);
                image.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

                    public void handle(MouseEvent arg0) {
                        if (handler.isCancelled()) {
                            return;
                        }
                        root.setDisable(true);
                        handler.handleCancel();
                    }
                });
                centerWrapper.add(image, 0, 0);
                centerWrapper.add((Node)label, 1, 0);
            } else {
                centerWrapper.add((Node)label, 0, 0);
            }
            ProgressList.this.background.setStyle((Node)root, BasicCssClasses.defaultBackground);
            root.setLeft((Node)imageView);
            root.setCenter((Node)centerWrapper);
            HBox progressStateWrapper = new HBox(new Node[]{progressState});
            progressStateWrapper.setAlignment(Pos.CENTER);
            root.setRight((Node)progressStateWrapper);
            handler.getProgressState().addListener((ChangeListener)new ChangeListener<Number>(){
                DecimalFormat df = new DecimalFormat("000");

                public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                    double value = newValue.doubleValue() * 100.0;
                    JavaFXUtil.runLater(() -> progressState.setText(this.df.format(value) + "%"));
                }
            });
            return root;
        }
    }
}

