/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.podcast.progress;

import de.mallongigi.podcast.model.Model;
import de.mallongigi.podcast.progress.AbstractProgressHandler;
import de.mallongigi.podcast.progress.ApplicationTask;
import de.mallongigi.podcast.progress.ProgressAction;
import de.mallongigi.podcast.progress.ProgressPool;
import de.mallongigi.singleton.Container;
import de.mallongigi.singleton.Inject;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

final class ProgressExecutor {
    private static final Logger LOG = Logger.getLogger(ProgressPool.class.getName());
    private final HashMap<ProgressAction, ExecutorService> executors = new HashMap();
    @Inject(safety=false)
    private ReentrantLock uiLocker;

    ProgressExecutor() {
        Container.inject(this);
        for (ProgressAction a : ProgressAction.values()) {
            this.executors.put(a, Executors.newSingleThreadExecutor());
        }
    }

    void shutdownNow() {
        this.executors.forEach((a, e) -> e.shutdownNow());
    }

    void execute(final AbstractProgressHandler<? extends Model> progressHandler) {
        ExecutorService executor = this.executors.get((Object)progressHandler.getActionType());
        if (executor == null) {
            LOG.log(Level.WARNING, "Fatal Error, cant find ExecutorService for \"" + progressHandler.getActionType().name() + "\" Action.");
            return;
        }
        try {
            LOG.info("Add to ExecutionService : " + String.valueOf(progressHandler.getClass()) + " / " + progressHandler.getProgressModel().getTitle());
            final ApplicationTask task = progressHandler.prepareProgress();
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    task.start();
                    try {
                        ProgressExecutor.this.uiLocker.lock();
                        progressHandler.executeFinishListener();
                    }
                    finally {
                        ProgressExecutor.this.uiLocker.unlock();
                    }
                }
            });
        }
        catch (Exception e) {
            progressHandler.setException(e);
            progressHandler.executeFinishListener();
        }
    }
}

