/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.podcast.progress;

import de.mallongigi.http.HttpFileLoader;
import de.mallongigi.images.model.ImageModel;
import de.mallongigi.podcast.model.Model;
import de.mallongigi.podcast.progress.AbstractProgressHandler;
import de.mallongigi.podcast.progress.ApplicationTask;
import de.mallongigi.podcast.progress.ProgressAction;
import de.mallongigi.podcast.progress.ProgressModel;
import java.net.URI;
import java.nio.file.FileSystems;

final class ImageDownloadHandler
extends AbstractProgressHandler<Model> {
    private boolean state = false;
    private final ImageModel imageModel;

    ImageDownloadHandler(Model targetModel, ImageModel imageModel) {
        super(new ProgressModel<Model>(targetModel), ProgressAction.imageDownload);
        this.imageModel = imageModel;
        this.addFinishListener(l -> imageModel.refrehUI());
    }

    @Override
    public boolean isCancelled() {
        return this.state;
    }

    @Override
    public void setProgressState(double value) {
    }

    @Override
    void handleCancel() {
        this.state = true;
    }

    @Override
    public ApplicationTask prepareProgress() throws Exception {
        if (this.model.getModel().getImageURL() == null || this.model.getModel().getImageURL().length() == 0) {
            return null;
        }
        HttpFileLoader fileLoader = new HttpFileLoader();
        fileLoader.setTargetFile(FileSystems.getDefault().getPath(this.imageModel.getLocation(), new String[0]));
        fileLoader.setUrl(new URI(this.model.getModel().getImageURL()).toURL());
        fileLoader.setDownloadHandler(this);
        return fileLoader;
    }
}

