/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.podcast.progress;

import de.mallongigi.dialog.ErrorDialog;
import de.mallongigi.ffmpeg.FFProbeMediaInfo;
import de.mallongigi.file.FileUtil;
import de.mallongigi.file.PodcastFilenameConverter;
import de.mallongigi.http.HttpFileLoader;
import de.mallongigi.http.feed.FeedURLConnector;
import de.mallongigi.http.feed.PodcastFeedConfigFactory;
import de.mallongigi.http.feed.PodcastFeedConnectionConfig;
import de.mallongigi.images.model.ImageIconModel;
import de.mallongigi.images.model.ImageModel;
import de.mallongigi.podcast.channel.model.PodcastChannelContainer;
import de.mallongigi.podcast.channel.navigation.PodcastChannelModel;
import de.mallongigi.podcast.episode.navigation.PodcastEpisodeModel;
import de.mallongigi.podcast.progress.AbstractProgressHandler;
import de.mallongigi.podcast.progress.ApplicationTask;
import de.mallongigi.podcast.progress.ProgressAction;
import de.mallongigi.podcast.progress.ProgressModel;
import de.mallongigi.podcast.progress.ProgressPool;
import de.mallongigi.resource.icons.DefaultIcons;
import de.mallongigi.resource.language.LanguageKeys;
import de.mallongigi.resource.language.LanguageResource;
import de.mallongigi.singleton.Inject;
import de.mallongigi.ui.concurrent.JavaFXUtil;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

final class EpisodeDownloadHandler
extends AbstractProgressHandler<PodcastEpisodeModel> {
    private static final Logger LOG = Logger.getLogger(EpisodeDownloadHandler.class.getName());
    @Inject
    private ProgressPool progressPool;
    @Inject(safety=false)
    private ReentrantLock uiLocker;
    @Inject
    private PodcastChannelContainer podcastChannelContainer;
    @Inject
    private LanguageResource languageResource;
    private boolean cancelDownload = false;
    private Exception exception;

    EpisodeDownloadHandler(PodcastEpisodeModel episode) {
        super(new ProgressModel<PodcastEpisodeModel>(episode), ProgressAction.download);
        this.getProgressModel().setTitle(episode.getTitle());
        this.getProgressModel().setImage(new ImageIconModel(episode.getImage().getLocation(), episode.getImage().getDeviceType(), DefaultIcons.DownloadEpisode));
        this.addFinishListener(l -> this.handleReady());
    }

    public void prepareDownload() {
        PodcastEpisodeModel episode = this.getProgressModel().getModel();
        this.podcastChannelContainer.addToNavigationView(episode);
        try {
            this.cancelDownload = false;
            ImageModel imageModel = episode.getImage();
            if (imageModel == null) {
                imageModel = episode.getChannel().getImage();
            }
            this.model.setImage(new ImageIconModel(imageModel.getLocation(), imageModel.getDeviceType(), DefaultIcons.DownloadEpisode));
            this.progressPool.addImageDownload(imageModel, episode);
        }
        catch (Exception e) {
            new ErrorDialog().show(LanguageKeys.errorMessageDownloadFile, e, episode.getUrl());
        }
    }

    public void handleReady() {
        final PodcastEpisodeModel episode = this.getProgressModel().getModel();
        episode.getState().setInPool(false);
        if (this.exception != null) {
            this.handleError();
            return;
        }
        if ((episode.getDuration() == null || episode.getDuration().isBlank() || episode.getDuration().equals("?")) && !this.cancelDownload) {
            try {
                episode.setDuration(new FFProbeMediaInfo().getDuration(episode.getChannel().getPodcastFilenameConverter().convertEpisode(episode)));
            }
            catch (IOException e) {
                episode.setDuration("?");
                LOG.log(Level.INFO, e.getMessage(), e);
            }
        }
        if (episode.getShownotes() == null) {
            try {
                PodcastChannelModel shownotesChannel = new PodcastChannelModel();
                shownotesChannel.setPodcastFeedUrl(episode.getChannel().getPodcastFeedUrl());
                PodcastFeedConnectionConfig config = new PodcastFeedConfigFactory().getConfig(episode.getChannel());
                PodcastChannelModel newModel = config.getPodcastChannelParser(true).parse(new FeedURLConnector(shownotesChannel, config));
                for (PodcastEpisodeModel e : newModel.getEpisodes()) {
                    if (!e.equals(episode) || e.getShownotes() == null) continue;
                    episode.setShownotes(e.getShownotes().toString());
                }
            }
            catch (Exception e) {
                LOG.log(Level.INFO, e.getMessage(), e);
            }
        }
        episode.getState().setPlayed(false);
        if (!this.cancelDownload) {
            episode.getState().setNew(false);
        }
        JavaFXUtil.runLater(new Runnable(){

            @Override
            public void run() {
                try {
                    EpisodeDownloadHandler.this.uiLocker.lock();
                    if (EpisodeDownloadHandler.this.cancelDownload) {
                        LOG.info(String.format("Cancel Download from : %s", episode.getFilename()));
                        EpisodeDownloadHandler.this.deleteFile(episode);
                    } else {
                        episode.setDownloaded(true);
                        episode.getState().setPresent(EpisodeDownloadHandler.this.isDownloadExists());
                    }
                    LOG.info(String.format("Episode refreshed after download %s", episode.getFilename()));
                    episode.setErrorMessage(null);
                    episode.setCurrentDownload(false);
                    EpisodeDownloadHandler.this.podcastChannelContainer.addToNavigationView(episode);
                }
                finally {
                    EpisodeDownloadHandler.this.uiLocker.unlock();
                }
            }
        });
    }

    private boolean isDownloadExists() {
        try {
            PodcastEpisodeModel episode = this.getProgressModel().getModel();
            PodcastChannelModel channel = episode.getChannel();
            PodcastFilenameConverter converter = channel.getPodcastFilenameConverter();
            Path fileName = converter.convertEpisode(episode);
            return fileName.toFile().exists();
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean deleteFile(PodcastEpisodeModel model) {
        Path file = null;
        try {
            file = model.getChannel().getPodcastFilenameConverter().convertEpisode(model);
        }
        catch (Exception e) {
            new ErrorDialog().show(LanguageKeys.errorMakeLocaleFile, e, model.getUrl());
            return false;
        }
        return FileUtil.delete(file);
    }

    @Override
    public boolean isCancelled() {
        return this.cancelDownload;
    }

    @Override
    public void handleCancel() {
        this.cancelDownload = true;
    }

    @Override
    public ProgressModel<PodcastEpisodeModel> getProgressModel() {
        return this.model;
    }

    @Override
    public ApplicationTask prepareProgress() throws Exception {
        PodcastEpisodeModel episode = this.getProgressModel().getModel();
        HttpFileLoader lf = new HttpFileLoader();
        lf.setTargetFile(episode.getChannel().getPodcastFilenameConverter().convertEpisode(episode));
        lf.setUrl(this.createUrl(episode.getUrl()));
        lf.setDownloadHandler(this);
        return lf;
    }

    private URL createUrl(String url) throws MalformedURLException, URISyntaxException {
        try {
            URL result = new URI(url).toURL();
            return result;
        }
        catch (Exception e) {
            if (url.startsWith("//")) {
                return this.createUrl("https:" + url);
            }
            throw e;
        }
    }

    public String toString() {
        PodcastEpisodeModel episode = this.getProgressModel().getModel();
        return episode.getTitle() + " - " + episode.getUrl();
    }

    private void handleError() {
        final PodcastEpisodeModel episode = this.getProgressModel().getModel();
        episode.getChannel().setCachHash(null);
        JavaFXUtil.runLater(new Runnable(){

            @Override
            public void run() {
                try {
                    EpisodeDownloadHandler.this.uiLocker.lock();
                    EpisodeDownloadHandler.this.deleteFile(episode);
                    episode.getState().setPresent(false);
                    episode.getState().setNew(true);
                    episode.setDownloaded(false);
                    episode.setErrorMessage(EpisodeDownloadHandler.this.languageResource.messageForKey(LanguageKeys.errorDownloadPodcastEpisode, episode.getUrl(), EpisodeDownloadHandler.this.exception.getMessage()));
                    episode.getChannel().refreshCurrentPodcastEpisodeSize();
                    episode.setCurrentDownload(false);
                    EpisodeDownloadHandler.this.podcastChannelContainer.addToNavigationView(episode);
                }
                finally {
                    EpisodeDownloadHandler.this.uiLocker.unlock();
                }
            }
        });
    }

    @Override
    public void setException(Exception e) {
        this.exception = e;
    }
}

