/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.podcast.progress;

import de.mallongigi.file.ClearChannelDatas;
import de.mallongigi.platform.OSPlatform;
import de.mallongigi.podcast.channel.navigation.PodcastChannelModel;
import de.mallongigi.podcast.progress.AbstractProgressHandler;
import de.mallongigi.podcast.progress.ApplicationTask;
import de.mallongigi.podcast.progress.ProgressAction;
import de.mallongigi.podcast.progress.ProgressModel;
import de.mallongigi.settings.model.ApplicationSettings;
import de.mallongigi.singleton.Inject;
import java.util.logging.Logger;

public final class ClearChannelDataHandler
extends AbstractProgressHandler<PodcastChannelModel> {
    private static final Logger LOG = Logger.getLogger(ClearChannelDataHandler.class.getName());
    @Inject
    private OSPlatform plattform;
    @Inject
    private ApplicationSettings appSettings;
    private boolean cancel = false;
    private ClearChannelDatas runnable;

    ClearChannelDataHandler() {
        super(new ProgressModel(), ProgressAction.copyToUsb);
        this.addFinishListener(l -> {
            LOG.info(String.format("%s is ready", this.getProgressModel().getTitle()));
            this.appSettings.setLastCleanTime(this.plattform.getSystemTime());
        });
    }

    @Override
    void handleCancel() {
        this.cancel = true;
        this.runnable.cancel();
    }

    @Override
    public boolean isCancelled() {
        return this.cancel;
    }

    @Override
    public ApplicationTask prepareProgress() throws Exception {
        return new ClearChannelDatas(this);
    }
}

