/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.podcast.progress;

import de.mallongigi.http.feed.RefreshPodcastChannelClient;
import de.mallongigi.images.model.ImageIconModel;
import de.mallongigi.podcast.channel.model.RefreshPodcastChannelModel;
import de.mallongigi.podcast.channel.navigation.PodcastChannelModel;
import de.mallongigi.podcast.model.UIState;
import de.mallongigi.podcast.progress.AbstractProgressHandler;
import de.mallongigi.podcast.progress.ApplicationTask;
import de.mallongigi.podcast.progress.ProgressAction;
import de.mallongigi.podcast.progress.ProgressModel;
import de.mallongigi.podcast.progress.ProgressPool;
import de.mallongigi.resource.icons.DefaultIcons;
import de.mallongigi.singleton.Inject;
import java.util.ArrayList;
import java.util.List;

final class ChannelRefreshHandler
extends AbstractProgressHandler<PodcastChannelModel> {
    @Inject
    private ProgressPool progressPool;
    private boolean cancel = false;
    private final List<RefreshPodcastChannelModel> result = new ArrayList<RefreshPodcastChannelModel>();
    private final RefreshPodcastChannelClient util = new RefreshPodcastChannelClient();

    ChannelRefreshHandler(PodcastChannelModel channel) {
        super(new ProgressModel<PodcastChannelModel>(channel), ProgressAction.download);
        this.getProgressModel().setTitle(channel.getTitle());
        this.getProgressModel().setImage(new ImageIconModel(channel.getImage().getLocation(), channel.getImage().getDeviceType(), DefaultIcons.RefreshPodcastChannel));
        this.addFinishListener(l -> {
            if (this.isCancelled()) {
                return;
            }
            for (RefreshPodcastChannelModel m : this.result) {
                this.util.progressAddEpisodes(m);
                m.currentPodcastChannelModel().clearErrorMessage();
            }
        });
    }

    @Override
    void handleCancel() {
        this.cancel = true;
    }

    @Override
    public boolean isCancelled() {
        return this.cancel;
    }

    @Override
    public ApplicationTask prepareProgress() throws Exception {
        return new ApplicationTask(){

            @Override
            public void start() {
                RefreshPodcastChannelClient util = new RefreshPodcastChannelClient();
                PodcastChannelModel m = (PodcastChannelModel)ChannelRefreshHandler.this.getProgressModel().getModel();
                try {
                    m.clearErrorMessage();
                    RefreshPodcastChannelModel refreshModel = util.refresh(m);
                    if (refreshModel != null) {
                        ChannelRefreshHandler.this.result.add(refreshModel);
                        m.clearErrorMessage();
                    } else {
                        m.clearErrorMessage();
                    }
                }
                catch (Exception e) {
                    m.setErrorMessage(e.getClass().getName() + ":" + e.getMessage());
                    m.getChannelItemState().setState(UIState.DOWNLOAD_READY);
                }
            }
        };
    }
}

