/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.podcast.progress;

import de.mallongigi.podcast.episode.navigation.PodcastEpisodeModel;
import de.mallongigi.podcast.model.Model;
import de.mallongigi.podcast.progress.ApplicationTask;
import de.mallongigi.podcast.progress.ProgressAction;
import de.mallongigi.podcast.progress.ProgressFinishListener;
import de.mallongigi.podcast.progress.ProgressModel;
import de.mallongigi.singleton.Container;
import de.mallongigi.ui.concurrent.JavaFXUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;

public abstract class AbstractProgressHandler<T extends Model>
implements Comparable<AbstractProgressHandler<T>> {
    private static final Logger LOG = Logger.getLogger(AbstractProgressHandler.class.getName());
    protected final ProgressModel<T> model;
    private final DoubleProperty progressState = new SimpleDoubleProperty();
    protected final ProgressAction actionType;
    private final List<ProgressFinishListener> finishListener = new ArrayList<ProgressFinishListener>();

    AbstractProgressHandler(ProgressModel<T> model, ProgressAction actionType) {
        this.model = model;
        this.actionType = actionType;
        Container.inject(this);
    }

    abstract void handleCancel();

    public abstract boolean isCancelled();

    public void setProgressState(double value) {
        this.progressState.set(value);
    }

    DoubleProperty getProgressState() {
        return this.progressState;
    }

    public ProgressModel<T> getProgressModel() {
        return this.model;
    }

    public void setException(Exception e) {
        LOG.log(Level.INFO, e.getMessage(), e);
    }

    abstract ApplicationTask prepareProgress() throws Exception;

    boolean canCancel() {
        return this.model.getModel() instanceof PodcastEpisodeModel;
    }

    void addFinishListener(ProgressFinishListener listener) {
        this.finishListener.add(listener);
    }

    void executeFinishListener() {
        final AbstractProgressHandler me = this;
        JavaFXUtil.optionalRunLater(new Runnable(){

            @Override
            public void run() {
                AbstractProgressHandler.this.finishListener.forEach(l -> l.ready(me));
            }
        });
    }

    public ProgressAction getActionType() {
        return this.actionType;
    }

    public int hashCode() {
        return Objects.hash(this.model);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractProgressHandler other = (AbstractProgressHandler)obj;
        return Objects.equals(this.model, other.model);
    }

    @Override
    public int compareTo(AbstractProgressHandler<T> handler) {
        if (handler == null) {
            return 1;
        }
        if (this.getProgressModel().isInProgress()) {
            return -1;
        }
        String title = handler.getProgressModel().getTitle();
        if (title == null) {
            return -1;
        }
        if (this.getProgressModel().getTitle() == null) {
            return 1;
        }
        return this.getProgressModel().getTitle().compareTo(title);
    }
}

