/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.podcast.episode.ui.buttons;

import de.mallongigi.dialog.ErrorDialog;
import de.mallongigi.file.FileUtil;
import de.mallongigi.file.PodcastFilenameConverter;
import de.mallongigi.podcast.channel.model.PodcastNavigationViewType;
import de.mallongigi.podcast.channel.navigation.PodcastChannelNavigationModel;
import de.mallongigi.podcast.episode.model.PodcastEpisodeModelState;
import de.mallongigi.podcast.episode.navigation.PodcastEpisodeListModel;
import de.mallongigi.podcast.episode.navigation.PodcastEpisodeModel;
import de.mallongigi.podcast.episode.ui.buttons.EpisodeBaseButton;
import de.mallongigi.resource.icons.DefaultIcons;
import de.mallongigi.resource.language.LanguageKeys;
import de.mallongigi.singleton.Inject;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.input.MouseEvent;

public final class DeleteButton
extends EpisodeBaseButton {
    @Inject
    private PodcastEpisodeListModel podcastContentListModel;
    @Inject
    private PodcastChannelNavigationModel podcastChannelNavigationModel;

    public DeleteButton(PodcastEpisodeModel model) {
        super(LanguageKeys.delete, DefaultIcons.Delete, model.getId() + "_" + LanguageKeys.delete.name());
        this.init(model);
    }

    private void init(final PodcastEpisodeModel model) {
        this.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent arg0) {
                try {
                    Path file = model.getChannel().getPodcastFilenameConverter().convertEpisode(model);
                    boolean result = FileUtil.delete(file);
                    if (result) {
                        if (model.hasClearMP3File()) {
                            FileUtil.delete(new PodcastFilenameConverter().convertToClearMP3Filename(model));
                        }
                        if (!model.isMP3Format()) {
                            Path f = model.getChannel().getPodcastFilenameConverter().convertToMP3File(model);
                            FileUtil.delete(f);
                        }
                        model.getState().setPresent(false);
                        model.getState().setNew(false);
                        DeleteButton.this.podcastChannelNavigationModel.getNewPodcastView().removeItem(model);
                        model.getChannel().refreshCurrentPodcastEpisodeSize();
                        if (model.hasChapters()) {
                            Path directory = FileUtil.getPodcastLocaleChapterDirectory(model);
                            Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(this){

                                @Override
                                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                                    FileUtil.delete(file);
                                    return FileVisitResult.CONTINUE;
                                }

                                @Override
                                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                                    FileUtil.delete(dir);
                                    return FileVisitResult.CONTINUE;
                                }
                            });
                        }
                    }
                }
                catch (Exception e) {
                    new ErrorDialog().show(LanguageKeys.errorMessageDeleteFileSystem, e, model.getUrl());
                }
            }
        });
        PodcastEpisodeModelState state = model.getState();
        this.setVisible(state);
        state.presentProperty().addListener(this.getChangeListener(state));
        state.inPoolProperty().addListener(this.getChangeListener(state));
    }

    private void setVisible(PodcastEpisodeModelState state) {
        if (state.isInPool()) {
            this.setVisible(false);
        } else if (this.podcastContentListModel.getCurrentChannelModel().getChannelType() == PodcastNavigationViewType.PodcastView) {
            this.setVisible(true);
        } else {
            this.setVisible(state.isPresent());
        }
    }

    private ChangeListener<Boolean> getChangeListener(final PodcastEpisodeModelState state) {
        return new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> arg0, Boolean oldValue, Boolean newValue) {
                DeleteButton.this.setVisible(state);
            }
        };
    }
}

