/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.podcast.episode.ui.buttons;

import de.mallongigi.podcast.episode.model.PodcastEpisodeModelState;
import de.mallongigi.podcast.episode.navigation.PodcastEpisodeModel;
import de.mallongigi.podcast.episode.ui.buttons.EpisodeBaseButton;
import de.mallongigi.podcast.progress.ProgressAction;
import de.mallongigi.podcast.progress.ProgressPool;
import de.mallongigi.resource.icons.DefaultIcons;
import de.mallongigi.resource.language.LanguageKeys;
import de.mallongigi.singleton.Inject;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.BooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.input.MouseEvent;

public final class CopyToUSBButton
extends EpisodeBaseButton {
    private static final Logger LOG = Logger.getLogger(CopyToUSBButton.class.getName());
    @Inject
    private ProgressPool progressPool;

    public CopyToUSBButton(PodcastEpisodeModel model) {
        super(LanguageKeys.copyToUsb, DefaultIcons.copyToStick, model.getId() + "_" + LanguageKeys.copyToUsb.name());
        this.init(model);
    }

    private void init(final PodcastEpisodeModel model) {
        this.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent arg0) {
                try {
                    Path file = model.getChannel().getPodcastFilenameConverter().convertEpisode(model);
                    if (!Files.exists(file, new LinkOption[0])) {
                        return;
                    }
                    CopyToUSBButton.this.progressPool.add(model, ProgressAction.copyToUsb);
                    model.setSelect(true);
                }
                catch (Exception e) {
                    LOG.log(Level.INFO, e.getMessage(), e);
                }
            }
        });
        this.refreshVisible(model);
        PodcastEpisodeModelState state = model.getState();
        state.presentProperty().addListener(this.getChangeListener(model));
        state.inPoolProperty().addListener(this.getChangeListener(model));
        model.getChannel().usbStickAvailableProperty().addListener(this.getChangeListener(model));
    }

    private ChangeListener<Boolean> getChangeListener(final PodcastEpisodeModel model) {
        return new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> arg0, Boolean oldValue, Boolean newValue) {
                CopyToUSBButton.this.refreshVisible(model);
            }
        };
    }

    private void refreshVisible(PodcastEpisodeModel item) {
        PodcastEpisodeModelState state = item.getState();
        BooleanProperty usbStickIsAvailable = item.getChannel().usbStickAvailableProperty();
        if (!usbStickIsAvailable.getValue().booleanValue()) {
            this.setVisible(false);
            return;
        }
        if (!state.isPresent()) {
            this.setVisible(false);
            return;
        }
        if (state.isInPool()) {
            this.setVisible(false);
            return;
        }
        this.setVisible(true);
    }
}

