/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.podcast.episode.ui.buttons;

import de.mallongigi.podcast.episode.model.PodcastEpisodeModelState;
import de.mallongigi.podcast.episode.navigation.PodcastEpisodeModel;
import de.mallongigi.podcast.episode.ui.buttons.EpisodeBaseButton;
import de.mallongigi.resource.icons.DefaultIcons;
import de.mallongigi.resource.language.LanguageKeys;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.MouseEvent;

public final class CopyButton
extends EpisodeBaseButton {
    private static final Logger LOG = Logger.getLogger(CopyButton.class.getName());

    public CopyButton(PodcastEpisodeModel model) {
        super(LanguageKeys.copy, DefaultIcons.Copy, model.getId() + "_" + LanguageKeys.copy.name());
        this.init(model);
    }

    private void init(final PodcastEpisodeModel model) {
        PodcastEpisodeModelState stateModel = model.getState();
        SimpleBooleanProperty isPresent = stateModel.presentProperty();
        this.visibleProperty().bind((ObservableValue)isPresent);
        this.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent arg0) {
                try {
                    Path file = model.getChannel().getPodcastFilenameConverter().convertEpisode(model);
                    ArrayList<File> listOfFiles = new ArrayList<File>();
                    listOfFiles.add(file.toFile());
                    ClipboardContent content = new ClipboardContent();
                    content.putFiles(listOfFiles);
                    Clipboard clipboard = Clipboard.getSystemClipboard();
                    clipboard.setContent((Map)content);
                    model.setSelect(true);
                }
                catch (Exception e) {
                    LOG.log(Level.INFO, e.getMessage(), e);
                }
            }
        });
    }
}

