/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.podcast.episode.ui.buttons;

import de.mallongigi.file.PodcastFilenameConverter;
import de.mallongigi.podcast.episode.navigation.PodcastEpisodeModel;
import de.mallongigi.podcast.episode.ui.buttons.EpisodeBaseButton;
import de.mallongigi.podcast.progress.ProgressAction;
import de.mallongigi.podcast.progress.ProgressPool;
import de.mallongigi.resource.icons.DefaultIcons;
import de.mallongigi.resource.language.LanguageKeys;
import de.mallongigi.settings.model.ApplicationSettings;
import de.mallongigi.singleton.Inject;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.input.MouseEvent;

public final class ConvertButton
extends EpisodeBaseButton {
    @Inject
    private ApplicationSettings appSettings;
    @Inject
    private ProgressPool progressPool;
    private final PodcastEpisodeModel model;

    public ConvertButton(PodcastEpisodeModel model) {
        super(LanguageKeys.convertToMP3, DefaultIcons.Music, model.getId() + "_" + LanguageKeys.convertToMP3.name());
        this.model = model;
        this.init();
    }

    private void refreshVisible() {
        if (!this.appSettings.isConverterAvailable()) {
            this.setVisible(false);
            return;
        }
        if (this.model.isMP3Format() || !this.model.getState().isPresent()) {
            this.setVisible(false);
        } else {
            this.setVisible(!this.mp3FileExists());
        }
    }

    private ChangeListener<Boolean> getChangeListener() {
        return new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> arg0, Boolean oldValue, Boolean newValue) {
                ConvertButton.this.refreshVisible();
            }
        };
    }

    private boolean mp3FileExists() {
        try {
            return Files.exists(new PodcastFilenameConverter().convertToMP3File(this.model), new LinkOption[0]);
        }
        catch (Exception e) {
            return false;
        }
    }

    private void init() {
        this.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent arg0) {
                ConvertButton.this.model.getState().setInPool(ConvertButton.this.progressPool.add(ConvertButton.this.model, ProgressAction.convert));
            }
        });
        this.refreshVisible();
        this.model.getState().presentProperty().addListener(this.getChangeListener());
        this.model.getState().inPoolProperty().addListener(this.getChangeListener());
    }
}

