/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.podcast.episode.ui.buttons;

import de.mallongigi.podcast.episode.model.PodcastEpisodeModelState;
import de.mallongigi.podcast.episode.navigation.PodcastEpisodeModel;
import de.mallongigi.podcast.episode.ui.buttons.EpisodeBaseButton;
import de.mallongigi.podcast.progress.ProgressAction;
import de.mallongigi.podcast.progress.ProgressPool;
import de.mallongigi.resource.icons.DefaultIcons;
import de.mallongigi.resource.language.LanguageKeys;
import de.mallongigi.settings.model.ApplicationSettings;
import de.mallongigi.singleton.Inject;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.input.MouseEvent;

public final class ClearMP3Button
extends EpisodeBaseButton {
    @Inject
    private ApplicationSettings appSettings;
    @Inject
    private ProgressPool progressPool;
    private final PodcastEpisodeModel model;

    public ClearMP3Button(PodcastEpisodeModel model) {
        super(LanguageKeys.clearMP3, DefaultIcons.clearMP3, model.getId() + "_" + LanguageKeys.clearMP3.name());
        this.model = model;
        this.init();
    }

    private void refreshVisible() {
        if (!this.appSettings.isConverterAvailable()) {
            this.setVisible(false);
            return;
        }
        if (this.model.isMP3Format()) {
            PodcastEpisodeModelState state = this.model.getState();
            this.setVisible(state.isPresent() && !this.model.hasClearMP3File());
        } else {
            this.setVisible(false);
        }
    }

    private ChangeListener<Boolean> createChangeListener() {
        return new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> arg0, Boolean oldValue, Boolean newValue) {
                ClearMP3Button.this.refreshVisible();
            }
        };
    }

    private void init() {
        final ClearMP3Button button = this;
        this.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent arg0) {
                ClearMP3Button.this.progressPool.add(ClearMP3Button.this.model, ProgressAction.clearMP3);
                button.setVisible(false);
            }
        });
        this.refreshVisible();
        this.model.getState().presentProperty().addListener(this.createChangeListener());
        this.model.getState().inPoolProperty().addListener(this.createChangeListener());
    }
}

