/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.podcast.episode.navigation;

import de.mallongigi.podcast.channel.navigation.PodcastChannelModel;
import de.mallongigi.podcast.channel.navigation.PodcastChannelViewModel;
import de.mallongigi.podcast.episode.navigation.PodcastEpisodeListChangeEvent;
import de.mallongigi.podcast.episode.navigation.PodcastEpisodeListListener;
import de.mallongigi.podcast.episode.navigation.PodcastEpisodeModel;
import de.mallongigi.resource.language.LanguageResource;
import de.mallongigi.singleton.Initialization;
import de.mallongigi.singleton.Inject;
import de.mallongigi.singleton.Singleton;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;

@Singleton
public final class PodcastEpisodeListModel {
    private static final int RELOAD_COUNT = 30;
    private ObservableList<PodcastEpisodeModel> list = FXCollections.observableArrayList(new ArrayList());
    @Inject
    private LanguageResource languageResource;
    private ObjectProperty<PodcastChannelModel> currentPodcastChannelModel = new SimpleObjectProperty();

    @Initialization
    private void init() {
        this.currentPodcastChannelModel.addListener((object, oldValue, newValue) -> {
            if (newValue instanceof PodcastChannelViewModel) {
                PodcastChannelViewModel view = (PodcastChannelViewModel)newValue;
                view.setPodcastEpisodeListListener(new PodcastEpisodeListListener(){

                    @Override
                    public void changed(PodcastEpisodeListChangeEvent event) {
                        PodcastChannelModel channel = event.channel();
                        if (!channel.equals(PodcastEpisodeListModel.this.currentPodcastChannelModel.get())) {
                            return;
                        }
                        List<PodcastEpisodeModel> source = channel.getEpisodes();
                        if (event.action() == 1) {
                            int size = PodcastEpisodeListModel.this.list.size();
                            if (!PodcastEpisodeListModel.this.list.removeAll(event.episodeList())) {
                                return;
                            }
                            if (size >= source.size()) {
                                List<PodcastEpisodeModel> subList = source.subList(PodcastEpisodeListModel.this.list.size(), source.size());
                                PodcastEpisodeListModel.this.list.addAll(subList);
                                return;
                            }
                            List<PodcastEpisodeModel> subList = source.subList(PodcastEpisodeListModel.this.list.size(), size);
                            PodcastEpisodeListModel.this.list.addAll(subList);
                        } else if (source.size() <= 30) {
                            PodcastEpisodeListModel.this.list.clear();
                            PodcastEpisodeListModel.this.list.addAll(source);
                        } else {
                            List<PodcastEpisodeModel> subList;
                            int size = Math.min(PodcastEpisodeListModel.this.list.size(), source.size());
                            if (size <= 30) {
                                size = 30;
                            }
                            if ((subList = source.subList(0, size)).equals(PodcastEpisodeListModel.this.list)) {
                                return;
                            }
                            PodcastEpisodeListModel.this.list.clear();
                            PodcastEpisodeListModel.this.list.addAll(subList);
                        }
                    }
                });
            }
            List<PodcastEpisodeModel> source = newValue.getEpisodes();
            this.list.clear();
            int size = Math.min(30, source.size());
            if (size > 0) {
                this.list.addAll(source.subList(0, size));
            }
        });
    }

    private void shift() {
        int maxCount;
        int count;
        List<PodcastEpisodeModel> source = ((PodcastChannelModel)this.currentPodcastChannelModel.get()).getEpisodes();
        if (this.list.size() >= source.size()) {
            return;
        }
        int positionLastEpisode = 0;
        if (!this.list.isEmpty() && (positionLastEpisode = this.getCurrentPosition((PodcastEpisodeModel)this.list.getLast()) + 1) == -1) {
            positionLastEpisode = 0;
        }
        if ((count = positionLastEpisode + 30) > (maxCount = source.size())) {
            count = maxCount;
        }
        List<PodcastEpisodeModel> subList = source.subList(positionLastEpisode, count);
        this.list.addAll(subList);
    }

    private int getCurrentPosition(PodcastEpisodeModel episode) {
        if (episode == null) {
            return 0;
        }
        List<PodcastEpisodeModel> source = ((PodcastChannelModel)this.currentPodcastChannelModel.get()).getEpisodes();
        return source.indexOf(episode);
    }

    public void expandCurrentView() {
        this.shift();
    }

    public void addListener(ListChangeListener<PodcastEpisodeModel> listener) {
        this.list.addListener(listener);
    }

    public boolean contains(PodcastEpisodeModel episode) {
        List<PodcastEpisodeModel> source = ((PodcastChannelModel)this.currentPodcastChannelModel.get()).getEpisodes();
        return source.contains(episode);
    }

    public PodcastChannelModel getCurrentChannelModel() {
        return (PodcastChannelModel)this.currentPodcastChannelModel.get();
    }

    public void setCurrentPodcastChannelModel(PodcastChannelModel currentPodcastChannelModel) {
        this.currentPodcastChannelModel.set((Object)currentPodcastChannelModel);
    }

    PodcastEpisodeModel[] getItems() {
        return (PodcastEpisodeModel[])this.list.toArray((Object[])new PodcastEpisodeModel[this.list.size()]);
    }

    ObjectProperty<PodcastChannelModel> currentPodcastCannelModel() {
        return this.currentPodcastChannelModel;
    }
}

