/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.podcast.episode.navigation;

import de.mallongigi.podcast.episode.navigation.PodcastEpisodeItem;
import de.mallongigi.podcast.episode.navigation.PodcastEpisodeListModel;
import de.mallongigi.podcast.episode.navigation.PodcastEpisodeModel;
import de.mallongigi.singleton.Component;
import de.mallongigi.singleton.Initialization;
import de.mallongigi.singleton.Inject;
import javafx.beans.property.DoubleProperty;
import javafx.collections.ListChangeListener;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.VBox;

@Component(makeAutoInstance=true)
public final class PodcastEpisodeList
extends VBox {
    @Inject
    private PodcastEpisodeListModel episodeList;
    private VBox listWrapper;
    private ScrollPane sideBarScroller;

    private PodcastEpisodeList() {
    }

    @Initialization
    private void init() {
        this.listWrapper = new VBox();
        this.sideBarScroller = new ScrollPane((Node)this.listWrapper);
        this.sideBarScroller.setFitToWidth(true);
        this.sideBarScroller.setFitToHeight(true);
        this.getChildren().add((Object)this.sideBarScroller);
        this.sideBarScroller.vvalueProperty().addListener(e -> {
            if (((DoubleProperty)e).doubleValue() >= 0.8) {
                this.episodeList.expandCurrentView();
            }
        });
        this.episodeList.addListener(new ListChangeListener<PodcastEpisodeModel>(){

            public void onChanged(ListChangeListener.Change<? extends PodcastEpisodeModel> event) {
                block8: {
                    if (!event.next()) {
                        return;
                    }
                    if (event.getRemovedSize() > 0) {
                        block0: for (PodcastEpisodeModel m : event.getRemoved()) {
                            for (Node n : PodcastEpisodeList.this.listWrapper.getChildren()) {
                                PodcastEpisodeItem i = ((PodcastEpisodeItem.PodcastEpisodeItemUI)n).getBusinessComponent();
                                if (!i.getPodcastModel().equals(m)) continue;
                                PodcastEpisodeList.this.listWrapper.getChildren().remove((Object)i.getUIComponent());
                                continue block0;
                            }
                        }
                    }
                    if (event.getAddedSize() <= 0) break block8;
                    if (PodcastEpisodeList.this.listWrapper.getChildren().isEmpty()) {
                        for (PodcastEpisodeModel m : event.getAddedSubList()) {
                            PodcastEpisodeItem pi = new PodcastEpisodeItem(m);
                            PodcastEpisodeList.this.listWrapper.getChildren().add((Object)pi.getUIComponent());
                        }
                    } else {
                        for (PodcastEpisodeModel m : event.getAddedSubList()) {
                            int position = this.getPosition(m);
                            PodcastEpisodeItem pi = new PodcastEpisodeItem(m);
                            PodcastEpisodeList.this.listWrapper.getChildren().add(position, (Object)pi.getUIComponent());
                        }
                    }
                }
            }

            private int getPosition(PodcastEpisodeModel m) {
                int position = 0;
                for (Node n : PodcastEpisodeList.this.listWrapper.getChildren()) {
                    PodcastEpisodeModel i = ((PodcastEpisodeItem.PodcastEpisodeItemUI)n).getBusinessComponent().getPodcastModel();
                    switch (m.compareTo(i)) {
                        case -1: {
                            ++position;
                            break;
                        }
                        case 0: 
                        case 1: {
                            return position;
                        }
                    }
                }
                return position;
            }
        });
        this.episodeList.currentPodcastCannelModel().addListener((object, oldValue, newValue) -> this.sideBarScroller.setVvalue(0.0));
    }
}

