/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.podcast.episode.model;

import de.mallongigi.images.model.ImageModel;
import de.mallongigi.mediaplayer.transcription.TranscriptionsLocations;
import de.mallongigi.podcast.channel.navigation.PodcastChannelModel;
import de.mallongigi.podcast.episode.model.Chapter;
import de.mallongigi.podcast.episode.model.PodcastEpisodeModelState;
import de.mallongigi.podcast.model.Model;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javafx.beans.property.SimpleStringProperty;

public class PodcastEpisodeDTO
implements Model {
    private String title;
    private String imageURL;
    private Date date;
    private String id;
    private String description;
    protected SimpleStringProperty duration = new SimpleStringProperty();
    private String url;
    private String length;
    private String subtitle;
    private String mediaType;
    private String link;
    private PodcastChannelModel channel;
    private ImageModel image = null;
    private PodcastEpisodeModelState state = new PodcastEpisodeModelState();
    private boolean isDownloaded = false;
    private double playerDuration = 0.0;
    private StringBuffer shownotes;
    private boolean waitForDownload = false;
    private List<Chapter> chapters = new ArrayList<Chapter>();
    private List<TranscriptionsLocations> transcriptions = new ArrayList<TranscriptionsLocations>();

    protected PodcastEpisodeDTO() {
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getImageURL() {
        return this.imageURL;
    }

    public void setImageURL(String image) {
        this.imageURL = image;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDuration() {
        return this.duration.getValue();
    }

    public void setDuration(String duration) {
        this.duration.setValue(duration);
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getLength() {
        return this.length;
    }

    public void setLength(String length) {
        this.length = length;
    }

    public String getSubtitle() {
        return this.subtitle;
    }

    public void setSubtitle(String subtitle) {
        this.subtitle = subtitle;
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(String encoding) {
        this.mediaType = encoding;
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public void setChannel(PodcastChannelModel channel) {
        this.channel = channel;
    }

    public PodcastChannelModel getChannel() {
        return this.channel;
    }

    public ImageModel getImage() {
        return this.image;
    }

    public void setImage(ImageModel image) {
        this.image = image;
    }

    public PodcastEpisodeModelState getState() {
        return this.state;
    }

    public boolean isDownloaded() {
        return this.isDownloaded;
    }

    public void setDownloaded(boolean isDownloaded) {
        this.isDownloaded = isDownloaded;
    }

    public void setPlayerDuration(double playerDuration) {
        this.playerDuration = playerDuration;
    }

    public double getPlayerDuration() {
        return this.playerDuration;
    }

    public void setShownotes(String shownotes) {
        this.shownotes = new StringBuffer(shownotes);
    }

    public StringBuffer getShownotes() {
        return this.shownotes;
    }

    public void setWaitForManuelDownload(boolean waitForDownload) {
        this.waitForDownload = waitForDownload;
    }

    public boolean isWaitForManuelDownload() {
        return this.waitForDownload;
    }

    public void addChapter(Chapter chapter) {
        this.chapters.add(chapter);
    }

    public Chapter[] getChapters() {
        return this.chapters.toArray(new Chapter[this.chapters.size()]);
    }

    public void addTranscription(TranscriptionsLocations location) {
        if (this.transcriptions.contains(location)) {
            return;
        }
        this.transcriptions.add(location);
    }

    public TranscriptionsLocations[] getTranscriptions() {
        return this.transcriptions.toArray(new TranscriptionsLocations[this.transcriptions.size()]);
    }

    public boolean hasTranscriptions() {
        return !this.transcriptions.isEmpty();
    }

    public boolean hasChapters() {
        return !this.chapters.isEmpty();
    }

    public int hashCode() {
        if (this.id != null) {
            return this.id.hashCode();
        }
        if (this.title != null) {
            return this.title.hashCode();
        }
        if (this.url != null) {
            return this.url.hashCode();
        }
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        Object object = obj;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PodcastEpisodeDTO.class}, (Object)object, n)) {
            case 0: {
                PodcastEpisodeDTO in = (PodcastEpisodeDTO)object;
                if (this.channel != null && in.getChannel() != null && this.channel.getId() != in.getChannel().getId()) {
                    return false;
                }
                if (this.url != null && this.url.equals(in.getUrl())) {
                    return true;
                }
                if (this.id != null && this.id.equals(in.getId())) {
                    return true;
                }
                return this.title != null && this.title.equals(in.getTitle()) && this.date != null && this.date.equals(in.date);
            }
        }
        return false;
    }
}

