/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.podcast.detailinformation;

import de.mallongigi.dialog.ErrorDialog;
import de.mallongigi.images.PixelImageLoader;
import de.mallongigi.podcast.channel.navigation.PodcastChannelModel;
import de.mallongigi.resource.language.LanguageKeys;
import de.mallongigi.singleton.Container;
import de.mallongigi.singleton.Inject;
import de.mallongigi.toolbar.usbstick.UsbStickAvailableService;
import de.mallongigi.ui.style.BasicCssClasses;
import de.mallongigi.ui.style.Styles;
import java.awt.Desktop;
import java.net.URI;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.image.ImageView;
import javafx.stage.Stage;

public final class DetailInformationController {
    @Inject
    private UsbStickAvailableService usbStickAvailableService;
    @Inject(safety=false)
    private Stage primaryStage;
    @Inject
    private Styles styles;
    @FXML
    private ImageView channelImage;
    @FXML
    private Label channelLabel;
    @FXML
    private TextField usbTargetPath;
    @FXML
    private Hyperlink homepageUrl;
    @FXML
    private Hyperlink feedUrl;
    @FXML
    private Label errorMessageLabel;
    @FXML
    private Label errorMessageText;
    @FXML
    private Label description;
    @FXML
    private CheckBox autoDownload;
    @FXML
    private Label channelIdValue;
    private PodcastChannelModel model;

    public DetailInformationController() {
        Container.inject(this);
    }

    @FXML
    private void initialize() {
        this.styles.setStyle((Node)this.channelLabel, BasicCssClasses.headline);
        this.homepageUrl.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent arg0) {
                Desktop desktop = Desktop.getDesktop();
                String url = DetailInformationController.this.homepageUrl.getText();
                try {
                    desktop.browse(new URI(url));
                }
                catch (Exception e1) {
                    new ErrorDialog().show(LanguageKeys.errorMessageExecuteBrowser, e1, url);
                }
            }
        });
        this.feedUrl.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent arg0) {
                Desktop desktop = Desktop.getDesktop();
                String url = DetailInformationController.this.feedUrl.getText();
                try {
                    desktop.browse(new URI(url));
                }
                catch (Exception e1) {
                    new ErrorDialog().show(LanguageKeys.errorMessageExecuteBrowser, e1, url);
                }
            }
        });
        this.usbTargetPath.focusedProperty().addListener((ov, oldV, hasFocus) -> {
            if (!hasFocus.booleanValue()) {
                this.model.setUsbPath(this.usbTargetPath.getText());
                this.usbStickAvailableService.updateNow();
            }
        });
        this.autoDownload.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> ov, Boolean old_val, Boolean new_val) {
                DetailInformationController.this.model.setAutomaticDownload(new_val);
            }
        });
        this.primaryStage.widthProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                DetailInformationController.this.description.setPrefWidth(newValue.doubleValue());
            }
        });
    }

    public void setChannelModel(PodcastChannelModel model) {
        this.model = model;
        this.channelIdValue.setText(String.valueOf(model.getId()));
        this.channelImage.setImage(new PixelImageLoader().create(model.getImage(), 128).image());
        this.channelLabel.setText(model.getTitle());
        this.homepageUrl.setText(model.getHomepage());
        this.feedUrl.setText(model.getPodcastFeedUrl());
        if (!model.hasErrorMessage()) {
            this.errorMessageLabel.setVisible(false);
            this.errorMessageText.setVisible(false);
        } else {
            this.errorMessageLabel.setVisible(true);
            this.errorMessageText.setText((String)model.errorProperty().get());
        }
        this.description.setMaxWidth(this.primaryStage.getWidth() * 0.95);
        this.description.setText(model.getDescription());
        if (model.getUsbPath() == null) {
            this.usbTargetPath.setText("");
        } else {
            this.usbTargetPath.setText(model.getUsbPath());
        }
        this.autoDownload.setSelected(model.isAutomaticDownload());
    }
}

