/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.podcast.channel.ui;

import de.mallongigi.podcast.channel.navigation.ChannelItemState;
import de.mallongigi.podcast.model.UIState;
import de.mallongigi.singleton.Container;
import de.mallongigi.singleton.Inject;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.scene.Cursor;
import javafx.stage.Stage;

public class SelectChannelService
extends Service<Boolean> {
    private static final Logger LOG = Logger.getLogger(SelectChannelService.class.getName());
    @Inject(safety=false)
    private Stage primaryStage;
    private final ChannelItemState item;

    public SelectChannelService(ChannelItemState item) {
        Container.inject((Object)this);
        this.item = item;
        this.primaryStage.getScene().setCursor(Cursor.WAIT);
    }

    protected Task<Boolean> createTask() {
        Task<Boolean> task = new Task<Boolean>(){

            protected Boolean call() throws Exception {
                if (SelectChannelService.this.item.isSelected()) {
                    return false;
                }
                return true;
            }
        };
        return task;
    }

    protected void succeeded() {
        try {
            Boolean result = (Boolean)this.getValue();
            if (result.booleanValue()) {
                this.item.setState(UIState.SELECT);
            }
        }
        catch (Exception e) {
            LOG.log(Level.INFO, e.getMessage(), e);
        }
        this.primaryStage.getScene().setCursor(Cursor.DEFAULT);
        super.succeeded();
    }

    protected void failed() {
        this.primaryStage.getScene().setCursor(Cursor.DEFAULT);
        super.failed();
    }
}

