/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.podcast.channel.ui;

import de.mallongigi.dialog.ErrorDialog;
import de.mallongigi.podcast.channel.model.PodcastChannelContainer;
import de.mallongigi.podcast.channel.model.PodcastNavigationViewType;
import de.mallongigi.podcast.channel.navigation.PodcastChannelModel;
import de.mallongigi.podcast.progress.ProgressPool;
import de.mallongigi.resource.language.LanguageKeys;
import de.mallongigi.settings.model.ApplicationSettings;
import de.mallongigi.singleton.Container;
import de.mallongigi.singleton.Inject;
import de.mallongigi.singleton.Singleton;
import java.util.List;
import javafx.concurrent.ScheduledService;
import javafx.concurrent.Task;
import javafx.util.Duration;

@Singleton
public class RefreshAutomaticServices
extends ScheduledService<Void> {
    @Inject
    private PodcastChannelContainer podcastChannelContainer;
    @Inject
    private ApplicationSettings settings;

    private RefreshAutomaticServices() {
    }

    public void start() {
        this.setPeriod(Duration.minutes((double)this.settings.getAutomaticRefreshTimerProperty().getValue().intValue()));
        this.setRestartOnFailure(true);
        super.start();
    }

    protected Task<Void> createTask() {
        return new Task<Void>(){

            protected Void call() {
                List<PodcastChannelModel> list = RefreshAutomaticServices.this.podcastChannelContainer.getPodcastChannels(PodcastNavigationViewType.Podcast);
                ProgressPool progressPool = Container.get(ProgressPool.class);
                progressPool.addClearData();
                progressPool.add(list);
                return null;
            }
        };
    }

    protected void succeeded() {
        super.succeeded();
    }

    protected void failed() {
        new ErrorDialog().show(LanguageKeys.errorRefreshAll, this.getException());
        super.failed();
    }
}

