/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.podcast.channel.ui;

import de.mallongigi.dialog.InitialLoadFeedDataDialog;
import de.mallongigi.http.feed.FeedURLConnector;
import de.mallongigi.http.feed.PodcastFeedConfigFactory;
import de.mallongigi.http.feed.PodcastFeedConnectionConfig;
import de.mallongigi.podcast.channel.model.NewPodcastChannelHelper;
import de.mallongigi.podcast.channel.navigation.PodcastChannelModel;
import de.mallongigi.resource.icons.DefaultIcons;
import de.mallongigi.resource.language.LanguageKeys;
import de.mallongigi.resource.language.LanguageResource;
import de.mallongigi.settings.model.ApplicationSettings;
import de.mallongigi.singleton.Container;
import de.mallongigi.singleton.Inject;
import de.mallongigi.singleton.Singleton;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.concurrent.Service;
import javafx.concurrent.Task;

@Singleton
public class AddPodcastChannelService
extends Service<PodcastChannelModel> {
    private static final Logger LOG = Logger.getLogger(AddPodcastChannelService.class.getName());
    private String url;
    private boolean showAlternative = true;
    private InitialLoadFeedDataDialog dialog;
    @Inject
    private LanguageResource languageResource;

    private AddPodcastChannelService() {
        Container.inject((Object)this);
    }

    public AddPodcastChannelService setUrl(String url) {
        this.url = url;
        return this;
    }

    public AddPodcastChannelService setDialog(InitialLoadFeedDataDialog dialog) {
        this.dialog = dialog;
        return this;
    }

    public AddPodcastChannelService setShowAlternative(boolean showAlternative) {
        this.showAlternative = showAlternative;
        return this;
    }

    protected Task<PodcastChannelModel> createTask() {
        this.dialog = new InitialLoadFeedDataDialog(DefaultIcons.AddPodcast);
        this.dialog.setContentText(this.url);
        this.dialog.show();
        return new Task<PodcastChannelModel>(){

            protected PodcastChannelModel call() throws Exception {
                try {
                    PodcastChannelModel dummy = new PodcastChannelModel();
                    dummy.setPodcastFeedUrl(AddPodcastChannelService.this.url);
                    PodcastFeedConnectionConfig config = new PodcastFeedConfigFactory().getConfig(dummy);
                    if (dummy.hasErrorMessage()) {
                        LOG.info((String)dummy.errorProperty().get());
                        AddPodcastChannelService.this.dialog.addInformation((String)dummy.errorProperty().get());
                        return null;
                    }
                    PodcastChannelModel model = config.getPodcastChannelParser(false).parse(new FeedURLConnector(dummy, config));
                    model.setId(Container.get(ApplicationSettings.class).nextPodcastChannelIdCount());
                    if (model.hasErrorMessage()) {
                        LOG.info((String)model.errorProperty().get());
                        AddPodcastChannelService.this.dialog.addInformation(AddPodcastChannelService.this.languageResource.messageForKey(LanguageKeys.errorMessageLoadFeed, AddPodcastChannelService.this.url));
                        return null;
                    }
                    return model;
                }
                catch (Exception e) {
                    LOG.log(Level.INFO, e.getMessage(), e);
                    AddPodcastChannelService.this.dialog.addInformation(AddPodcastChannelService.this.languageResource.messageForKey(LanguageKeys.errorMessageLoadFeed, AddPodcastChannelService.this.url));
                    return null;
                }
            }
        };
    }

    protected void succeeded() {
        String result;
        PodcastChannelModel model = (PodcastChannelModel)this.getValue();
        if (model == null) {
            this.dialog.enableButton();
            return;
        }
        if (!model.getAlternativ().isEmpty() && this.showAlternative && !(result = this.dialog.selectAlternative(model)).equals(model.getPodcastFeedUrl())) {
            this.dialog.close();
            model.setPodcastFeedUrl(result);
            this.setUrl(model.getPodcastFeedUrl()).setShowAlternative(false).restart();
            return;
        }
        try {
            new NewPodcastChannelHelper().addPodcastFeed(model, true);
        }
        catch (Exception e) {
            this.dialog.addInformation(this.languageResource.messageForKey(LanguageKeys.errorMessageLoadFeed, this.url));
        }
        if (!this.dialog.hasInformation()) {
            this.dialog.close();
        }
        this.dialog.enableButton();
    }
}

