/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.podcast.channel.navigation;

import de.mallongigi.podcast.channel.model.PodcastChannelContainer;
import de.mallongigi.podcast.channel.model.PodcastNavigationViewType;
import de.mallongigi.podcast.channel.navigation.PodcastChannelItem;
import de.mallongigi.podcast.channel.navigation.PodcastChannelModel;
import de.mallongigi.podcast.channel.navigation.PodcastChannelNavigationModel;
import de.mallongigi.podcast.channel.navigation.PodcastChannelViewModel;
import de.mallongigi.podcast.episode.navigation.PodcastEpisodeModel;
import de.mallongigi.podcast.model.UIState;
import de.mallongigi.resource.icons.DefaultIcons;
import de.mallongigi.resource.language.LanguageKeys;
import de.mallongigi.resource.language.LanguageResource;
import de.mallongigi.singleton.Component;
import de.mallongigi.singleton.Initialization;
import de.mallongigi.singleton.Inject;
import de.mallongigi.ui.elements.UIButton;
import java.util.ArrayList;
import java.util.List;
import javafx.animation.FadeTransition;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.util.Duration;

@Component(makeAutoInstance=true)
public final class PodcastChannelNavigation
extends VBox {
    @Inject
    private PodcastChannelContainer podcastChannelContainer;
    @Inject
    private PodcastChannelNavigationModel podcastChannelNavigationModel;
    @Inject
    private LanguageResource languageResource;

    private PodcastChannelNavigation() {
    }

    @Initialization
    public void init() {
        final ObservableList podcastChannelItems = FXCollections.observableList(new ArrayList());
        final VBox podcastViewList = new VBox();
        ScrollPane sideBarScroller = new ScrollPane((Node)podcastViewList);
        sideBarScroller.setFitToWidth(true);
        sideBarScroller.setFitToHeight(true);
        final PodcastChannelViewModel newEpisodeView = this.podcastChannelNavigationModel.getNewPodcastView();
        for (PodcastChannelModel podcastChannelModel : this.podcastChannelContainer.getPodcastChannels(PodcastNavigationViewType.Podcast)) {
            for (PodcastEpisodeModel pm : podcastChannelModel.getEpisodes()) {
                if (pm.getState().isPresent()) continue;
            }
        }
        this.podcastChannelContainer.add(false, newEpisodeView);
        PodcastChannelItem newEpisodeItems = new PodcastChannelItem(newEpisodeView);
        for (PodcastChannelModel channel : this.podcastChannelContainer.getPodcastChannels(PodcastNavigationViewType.Podcast)) {
            PodcastChannelItem pci = new PodcastChannelItem(channel);
            podcastChannelItems.add((Object)pci);
            podcastViewList.getChildren().add((Object)pci);
        }
        TextField textField = new TextField();
        textField.setPromptText(this.languageResource.messageForKey(LanguageKeys.filterPodcastChannels));
        textField.prefWidthProperty().bind((ObservableValue)this.widthProperty());
        textField.textProperty().bindBidirectional((Property)this.podcastChannelNavigationModel.podcastFilterProperty());
        this.podcastChannelNavigationModel.podcastFilterProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> arg0, String current, String next) {
                String value = next.toLowerCase();
                podcastViewList.getChildren().clear();
                for (PodcastChannelItem channel : podcastChannelItems) {
                    if (channel.getPodcastChannel().getChannelItemState().isSelected()) {
                        podcastViewList.getChildren().add((Object)channel);
                        continue;
                    }
                    PodcastChannelModel model = channel.getPodcastChannel();
                    if (model.getTitle().toLowerCase().indexOf(value) != -1) {
                        podcastViewList.getChildren().add((Object)channel);
                        continue;
                    }
                    if (model.getUsbPath() == null || model.getUsbPath().indexOf(value) == -1) continue;
                    podcastViewList.getChildren().add((Object)channel);
                }
            }
        });
        UIButton clearFilterButton = new UIButton(DefaultIcons.close);
        clearFilterButton.setOnAction(e -> filterTextField.setText(""));
        HBox filterWrapper = new HBox();
        filterWrapper.setAlignment(Pos.CENTER);
        filterWrapper.getChildren().addAll((Object[])new Node[]{textField, clearFilterButton});
        this.podcastChannelContainer.addListener(new ListChangeListener<PodcastChannelModel>(){

            public void onChanged(ListChangeListener.Change<? extends PodcastChannelModel> c) {
                if (!c.next()) {
                    return;
                }
                if (c.wasAdded()) {
                    for (PodcastChannelModel model : c.getAddedSubList()) {
                        PodcastChannelItem item = new PodcastChannelItem(model);
                        podcastChannelItems.add((Object)item);
                        podcastViewList.getChildren().add((Object)item);
                    }
                    return;
                }
                if (c.wasRemoved()) {
                    for (PodcastChannelModel model : c.getRemoved()) {
                        List<PodcastChannelItem> found = podcastChannelItems.stream().filter(pci -> pci.getPodcastChannel().equals(model)).toList();
                        if (found.isEmpty()) {
                            return;
                        }
                        PodcastChannelItem removeItem = found.getFirst();
                        FadeTransition fade = new FadeTransition(Duration.millis((double)300.0), (Node)removeItem);
                        fade.setFromValue(1.0);
                        fade.setToValue(0.0);
                        fade.setOnFinished(event -> {
                            podcastChannelItems.remove((Object)removeItem);
                            podcastViewList.getChildren().remove((Object)removeItem);
                        });
                        fade.play();
                    }
                    newEpisodeView.getChannelItemState().setState(UIState.SELECT);
                    return;
                }
            }
        });
        this.getChildren().addAll((Object[])new Node[]{filterWrapper, newEpisodeItems, podcastViewList, sideBarScroller});
        newEpisodeView.getChannelItemState().setState(UIState.SELECT);
    }
}

