/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.podcast.channel.navigation;

import de.mallongigi.images.elements.UIImageFactory;
import de.mallongigi.platform.OSPlatform;
import de.mallongigi.podcast.channel.model.PodcastChannelContainer;
import de.mallongigi.podcast.channel.model.PodcastNavigationViewType;
import de.mallongigi.podcast.channel.navigation.PodcastChannelCssClass;
import de.mallongigi.podcast.channel.navigation.PodcastChannelModel;
import de.mallongigi.podcast.channel.navigation.PodcastChannelNavigationModel;
import de.mallongigi.podcast.episode.navigation.PodcastEpisodeListModel;
import de.mallongigi.podcast.model.UIState;
import de.mallongigi.resource.icons.DefaultIcons;
import de.mallongigi.resource.icons.IconColors;
import de.mallongigi.resource.icons.IconFactory;
import de.mallongigi.resource.language.LanguageKeys;
import de.mallongigi.resource.language.LanguageResource;
import de.mallongigi.singleton.Container;
import de.mallongigi.singleton.Inject;
import de.mallongigi.toolbar.ApplicationToolbarModel;
import de.mallongigi.ui.elements.UITooltip;
import de.mallongigi.ui.style.BasicCssClasses;
import de.mallongigi.ui.style.Styles;
import java.util.Calendar;
import java.util.Date;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;

public final class PodcastChannelItem
extends GridPane {
    @Inject
    private Styles styles;
    @Inject
    private PodcastChannelNavigationModel podcastChannelNavigationModel;
    @Inject
    private OSPlatform plattform;
    @Inject
    private PodcastChannelContainer podcastChannels;
    @Inject
    private ApplicationToolbarModel toolbarModel;
    @Inject
    private PodcastEpisodeListModel podcastContentListModel;
    @Inject
    private IconFactory iconFactory;
    @Inject
    private UIImageFactory uiImageFactory;
    @Inject
    private LanguageResource languageResource;
    private final PodcastChannelModel model;

    PodcastChannelItem(PodcastChannelModel model) {
        Container.inject((Object)this);
        this.model = model;
        this.init();
    }

    private void init() {
        this.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                PodcastChannelItem.this.podcastChannelNavigationModel.setSelectedChannel(PodcastChannelItem.this.model);
            }
        });
        final PodcastChannelItem me = this;
        this.model.getChannelItemState().stateProperty().addListener((ChangeListener)new ChangeListener<UIState>(){

            public void changed(ObservableValue<? extends UIState> observable, UIState oldValue, UIState newValue) {
                if (newValue == UIState.SELECT) {
                    if (oldValue == UIState.SELECT) {
                        return;
                    }
                    for (PodcastChannelModel m : PodcastChannelItem.this.podcastChannels.getPodcastChannels(PodcastNavigationViewType.All)) {
                        if (!m.getChannelItemState().isSelected() || m.equals(PodcastChannelItem.this.model)) continue;
                        m.getChannelItemState().setState(UIState.DEFAULT);
                    }
                    PodcastChannelItem.this.podcastContentListModel.setCurrentPodcastChannelModel(PodcastChannelItem.this.model);
                    PodcastChannelItem.this.toolbarModel.setSelectedChannel(PodcastChannelItem.this.model);
                }
                PodcastChannelItem.this.styles.setStyle((Node)me, PodcastChannelItem.this.model.getChannelItemState().getCurrentStateColor());
            }
        });
        this.setPadding(new Insets(5.0));
        this.setHgap(5.0);
        Node refreshError = this.iconFactory.create(DefaultIcons.RefreshError, 22, IconColors.Error);
        HBox unPlayedWrapper = new HBox();
        Label unPlayed = new Label();
        this.styles.setStyle((Node)unPlayed, PodcastChannelCssClass.podcastItemCount);
        unPlayed.textProperty().bind((ObservableValue)this.model.getCurrentEpisodeProperty());
        unPlayedWrapper.getChildren().add((Object)unPlayed);
        Label label = new Label(this.model.getTitle() + " " + this.getLastDate());
        label.setWrapText(true);
        if (this.model.getChannelType() == PodcastNavigationViewType.PodcastView) {
            label.setFont(Font.font((String)label.getFont().getFamily(), (FontWeight)FontWeight.BOLD, (double)20.0));
        }
        if (this.model.getChannelType() == PodcastNavigationViewType.Podcast) {
            final UITooltip tooltip = new UITooltip(300);
            tooltip.setText(this.model.getDescription());
            tooltip.install((Node)this);
            this.model.errorProperty().addListener((ChangeListener)new ChangeListener<String>(){

                public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                    if (newValue == null || newValue.trim().isEmpty()) {
                        if (!PodcastChannelItem.this.model.getDescription().isEmpty()) {
                            tooltip.setText(PodcastChannelItem.this.model.getDescription());
                        }
                    } else {
                        tooltip.setText(newValue);
                    }
                }
            });
            refreshError.visibleProperty().bind((ObservableValue)this.model.errorProperty().isNotEmpty());
        } else {
            refreshError.setVisible(false);
        }
        StackPane errorWrapper = new StackPane();
        errorWrapper.getChildren().add((Object)refreshError);
        errorWrapper.setMaxWidth(32.0);
        errorWrapper.setMaxHeight(32.0);
        StackPane layout = new StackPane();
        layout.getChildren().addAll((Object[])new Node[]{unPlayedWrapper, refreshError});
        this.add(this.uiImageFactory.create(this.model, 48), 0, 0);
        this.add((Node)layout, 1, 0);
        this.add((Node)label, 2, 0);
        this.styles.setStyle((Node)this, BasicCssClasses.defaultBackground);
        this.setId(this.model.getId() + "_channelItem");
    }

    PodcastChannelModel getPodcastChannel() {
        return this.model;
    }

    private String getLastDate() {
        Date d = this.model.getDateLastEpisode();
        if (d == null || this.model.getChannelType() == PodcastNavigationViewType.PodcastView) {
            return "";
        }
        Calendar channelCalendar = this.plattform.getCalendar();
        channelCalendar.setTime(new Date(this.plattform.getSystemTime() - d.getTime()));
        int year = channelCalendar.get(1) - 1970;
        if (year == 1) {
            return "\n" + this.languageResource.messageForKey(LanguageKeys.lastUpdate, String.valueOf(year));
        }
        if (year > 1) {
            return "\n" + this.languageResource.messageForKey(LanguageKeys.lastUpdate, String.valueOf(year)) + "s";
        }
        return "";
    }
}

