/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.podcast.channel.navigation;

import de.mallongigi.podcast.model.UIState;
import de.mallongigi.ui.style.BasicCssClasses;
import de.mallongigi.ui.style.CssClass;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;

public final class ChannelItemState {
    private final ObjectProperty<UIState> currentState = new SimpleObjectProperty((Object)UIState.DEFAULT);
    private final ObjectProperty<UIState> lastState = new SimpleObjectProperty((Object)UIState.DEFAULT);

    ChannelItemState() {
    }

    public CssClass getCurrentStateColor() {
        return switch ((UIState)((Object)this.currentState.get())) {
            case UIState.SELECT -> BasicCssClasses.selectedBackground;
            default -> BasicCssClasses.defaultBackground;
        };
    }

    public boolean isSelected() {
        UIState value = (UIState)((Object)this.currentState.get());
        if (value.equals((Object)UIState.DOWNLOAD)) {
            value = (UIState)((Object)this.lastState.get());
        }
        return value.equals((Object)UIState.SELECT);
    }

    public void setState(UIState state) {
        if (state.equals((Object)UIState.DOWNLOAD_READY)) {
            this.currentState.set((Object)((UIState)((Object)this.lastState.get())));
            this.lastState.set((Object)UIState.DEFAULT);
            return;
        }
        this.lastState.set((Object)((UIState)((Object)this.currentState.get())));
        this.currentState.set((Object)state);
    }

    ObjectProperty<UIState> stateProperty() {
        return this.currentState;
    }
}

