/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.podcast.channel.model;

import de.mallongigi.podcast.channel.model.PodcastNavigationViewType;
import de.mallongigi.podcast.channel.navigation.PodcastChannelModel;
import de.mallongigi.podcast.channel.navigation.PodcastChannelNavigationModel;
import de.mallongigi.podcast.channel.navigation.PodcastChannelViewModel;
import de.mallongigi.podcast.episode.navigation.PodcastEpisodeModel;
import de.mallongigi.podcast.model.UIState;
import de.mallongigi.resource.language.LanguageKeys;
import de.mallongigi.resource.language.LanguageResource;
import de.mallongigi.singleton.Container;
import de.mallongigi.singleton.Inject;
import de.mallongigi.singleton.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;

@Singleton(makeAutoInstance=false)
public final class PodcastChannelContainer {
    private static final Logger LOG = Logger.getLogger(PodcastChannelContainer.class.getName());
    private final ObservableList<PodcastChannelModel> container = FXCollections.observableList(new ArrayList());
    @Inject
    private PodcastChannelNavigationModel podcastChannelNavigationModel;
    @Inject
    private LanguageResource languageResource;

    public PodcastChannelContainer(List<PodcastChannelModel> list) {
        Container.addAndInject(this);
        this.container.addAll(list);
    }

    public void addListener(ListChangeListener<PodcastChannelModel> listener) {
        this.container.addListener(listener);
    }

    public void add(boolean autoSelect, PodcastChannelModel ... items) {
        for (PodcastChannelModel item : items) {
            if (this.container.contains((Object)item)) continue;
            this.container.add((Object)item);
            if (!autoSelect) continue;
            item.getChannelItemState().setState(UIState.SELECT);
        }
        this.sort();
        this.refreshViews();
    }

    public void remove(PodcastChannelModel item) {
        this.container.remove((Object)item);
        this.sort();
        this.getPodcastChannels(PodcastChannelViewModel.class, PodcastNavigationViewType.PodcastView).forEach(v -> {
            for (PodcastEpisodeModel i : v.getEpisodes()) {
                if (!i.getChannel().equals(item)) continue;
                v.removeItem(i);
            }
        });
    }

    private <T> List<T> getPodcastChannels(Class<T> generic, PodcastNavigationViewType type) {
        ArrayList result = new ArrayList();
        if (type == PodcastNavigationViewType.All) {
            this.container.forEach(k -> result.add(generic.cast(k)));
            return result;
        }
        this.container.forEach(k -> {
            if (k.getChannelType() == type) {
                result.add(generic.cast(k));
            }
        });
        return result;
    }

    public List<PodcastChannelModel> getPodcastChannels(PodcastNavigationViewType type) {
        if (type == PodcastNavigationViewType.All) {
            return new ArrayList<PodcastChannelModel>((Collection<PodcastChannelModel>)this.container);
        }
        ArrayList<PodcastChannelModel> result = new ArrayList<PodcastChannelModel>();
        this.container.forEach(k -> {
            if (k.getChannelType() == type) {
                result.add((PodcastChannelModel)k);
            }
        });
        return result;
    }

    private PodcastChannelModel getEpisodeView(String title) {
        try {
            PodcastChannelModel result = this.container.stream().filter(x -> x.getChannelType() == PodcastNavigationViewType.PodcastView && x.getTitle().equals(title)).findFirst().get();
            return result;
        }
        catch (NoSuchElementException e) {
            LOG.log(Level.INFO, e.getMessage(), e);
            return null;
        }
    }

    public void addToNavigationView(PodcastEpisodeModel episode) {
        this.podcastChannelNavigationModel.getNewPodcastView().add(episode);
    }

    public void addToNavigationView(List<PodcastEpisodeModel> episodes) {
        this.podcastChannelNavigationModel.getNewPodcastView().add(episodes);
    }

    private void refreshViews() {
        LanguageKeys[] keys;
        for (LanguageKeys type : keys = new LanguageKeys[]{LanguageKeys.newPodcastEpisodeView}) {
            PodcastChannelModel view = this.getEpisodeView(this.languageResource.messageForKey(type));
            if (view == null) {
                return;
            }
            ArrayList<PodcastEpisodeModel> items = new ArrayList<PodcastEpisodeModel>();
            this.getPodcastChannels(PodcastNavigationViewType.Podcast).forEach(k -> {
                for (PodcastEpisodeModel im : k.getEpisodes()) {
                    if (!im.getState().isPresent() && !im.isWaitForManuelDownload()) continue;
                    items.add(im);
                }
            });
            view.add(items);
        }
    }

    private void sort() {
        this.container.sort((Comparator)new Comparator<PodcastChannelModel>(this){

            @Override
            public int compare(PodcastChannelModel o1, PodcastChannelModel o2) {
                if (o1 == null && o2 == null) {
                    return 0;
                }
                if (o1 == null) {
                    return 1;
                }
                if (o2 == null) {
                    return 2;
                }
                String title1 = o1.getTitle();
                if (title1 == null) {
                    return 1;
                }
                String title2 = o2.getTitle();
                if (title2 == null) {
                    return 2;
                }
                return title1.toLowerCase().compareTo(title2.toLowerCase());
            }
        });
    }

    public int size() {
        return this.getPodcastChannels(PodcastNavigationViewType.Podcast).size();
    }
}

