/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.podcast.channel.model;

import de.mallongigi.dialog.InitialLoadFeedDataDialog;
import de.mallongigi.file.FileUtil;
import de.mallongigi.images.model.ImageModelFactory;
import de.mallongigi.podcast.channel.model.PodcastChannelContainer;
import de.mallongigi.podcast.channel.navigation.PodcastChannelModel;
import de.mallongigi.podcast.episode.navigation.PodcastEpisodeModel;
import de.mallongigi.resource.language.LanguageKeys;
import de.mallongigi.resource.language.LanguageResource;
import de.mallongigi.singleton.Container;
import de.mallongigi.singleton.Inject;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;

public final class NewPodcastChannelHelper {
    private static final Logger LOG = Logger.getLogger(NewPodcastChannelHelper.class.getName());
    @Inject(safety=false)
    private ReentrantLock lock;
    @Inject
    private PodcastChannelContainer podcastChannelContainer;
    @Inject
    private LanguageResource languageResource;
    @Inject
    private ImageModelFactory imageModelFactory;

    public NewPodcastChannelHelper() {
        Container.inject(this);
    }

    public void addPodcastFeed(PodcastChannelModel model, boolean autoSelect) throws IOException {
        this.makePodcastDir(model);
        model.setImage(this.imageModelFactory.create(model));
        model.getEpisodes().forEach(e -> e.setImage(this.imageModelFactory.create((PodcastEpisodeModel)e)));
        this.podcastChannelContainer.add(autoSelect, model);
    }

    public void makePodcastDir(PodcastChannelModel model) throws IOException {
        String title = FileUtil.convertToLocalEncoding(model.getTitle().toLowerCase());
        Path path = FileUtil.getPodcastHomeDirectory().resolve(title);
        Files.createDirectories(path, new FileAttribute[0]);
        model.setLocaleDirectory(path.toString());
    }

    public void addErrorMessage(final Exception e, final String url, final InitialLoadFeedDataDialog importDialog) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    NewPodcastChannelHelper.this.lock.lock();
                    LOG.log(Level.INFO, "Import " + url, e);
                    importDialog.addInformation(NewPodcastChannelHelper.this.languageResource.messageForKey(LanguageKeys.errorMessageLoadFeed, url));
                    importDialog.addInformation(e.getMessage());
                    importDialog.addFail();
                }
                finally {
                    NewPodcastChannelHelper.this.lock.unlock();
                }
            }
        });
    }
}

