/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.platform;

import com.sun.jna.Platform;
import de.mallongigi.platform.LinuxPlattform;
import de.mallongigi.platform.OSPlatform;
import de.mallongigi.platform.WindowsPlatform;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Calendar;
import java.util.Date;
import javafx.scene.control.Dialog;
import javafx.stage.Window;

public class PlattformFactory {
    private PlattformFactory() {
    }

    public static OSPlatform createPlatformSingleton() {
        OSPlatform instance = Platform.isWindows() ? new WindowsPlatform() : (Platform.isLinux() ? new LinuxPlattform() : new OSPlatform(){

            @Override
            public void resetScreenSaverState() {
            }

            @Override
            public void init() {
            }

            @Override
            public void disableScreenSaver() {
            }

            @Override
            public long getSystemTime() {
                return System.currentTimeMillis();
            }

            @Override
            public Date getSystemDate() {
                return new Date();
            }

            @Override
            public Calendar getCalendar() {
                Calendar c = Calendar.getInstance();
                c.setTimeInMillis(this.getSystemTime());
                return c;
            }

            @Override
            public void setDarkMode(Window stage) {
            }

            @Override
            public void setDarkMode(Dialog<?> dialog) {
            }

            @Override
            public void open(Path path) throws IOException {
                Runtime.getRuntime().exec(new String[]{"xdg-open file://" + path.toString()});
            }

            @Override
            public String getFFMPEGDefaulPath() {
                return "";
            }
        });
        instance.init();
        return instance;
    }
}

