/*
 * Decompiled with CFR 0.152.
 */
package de.mallongigi.opml;

import de.mallongigi.opml.Outline;
import de.mallongigi.podcast.channel.model.PodcastChannelContainer;
import de.mallongigi.podcast.channel.model.PodcastChannelFeedType;
import de.mallongigi.podcast.channel.model.PodcastNavigationViewType;
import de.mallongigi.podcast.channel.navigation.PodcastChannelModel;
import de.mallongigi.singleton.Container;
import de.mallongigi.singleton.Inject;
import java.io.FileReader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javafx.concurrent.Task;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;

public final class OPMLLoaderTask
extends Task<List<Outline>> {
    private static final Logger LOG = Logger.getLogger(OPMLLoaderTask.class.getName());
    @Inject
    private PodcastChannelContainer podcastChannelContainer;
    private Path opmlFile;

    OPMLLoaderTask() {
        Container.inject((Object)this);
    }

    public void setFile(Path file) {
        this.opmlFile = file;
    }

    public List<Outline> call() throws Exception {
        ArrayList<Outline> feedList = new ArrayList<Outline>();
        FileReader fileReader = new FileReader(this.opmlFile.toFile());
        XMLInputFactory factory = XMLInputFactory.newInstance();
        XMLStreamReader reader = factory.createXMLStreamReader(fileReader);
        boolean searchElement = false;
        while (reader.hasNext()) {
            int event = reader.next();
            switch (event) {
                case 1: {
                    int count;
                    QName element = reader.getName();
                    if (element.getLocalPart() == null || !element.getLocalPart().equals("outline") || (count = reader.getAttributeCount()) == 0) break;
                    Outline outline = new Outline();
                    block18: for (int i = 0; i < count; ++i) {
                        String attrName;
                        switch (attrName = reader.getAttributeLocalName(i)) {
                            case "xmlUrl": 
                            case "jsonUrl": {
                                LOG.info("OPML Import found : " + reader.getAttributeValue(i));
                                outline.setUrl(reader.getAttributeValue(i));
                                continue block18;
                            }
                            case "type": {
                                outline.setType(reader.getAttributeValue(i));
                                continue block18;
                            }
                            case "title": 
                            case "text": {
                                outline.setTitle(reader.getAttributeValue(i));
                                continue block18;
                            }
                            default: {
                                LOG.info("Import OPML: ignore Attribute - " + attrName);
                            }
                        }
                    }
                    if (!this.checkOutline(outline)) break;
                    feedList.add(outline);
                    break;
                }
                case 4: {
                    break;
                }
                case 2: {
                    if (!searchElement) break;
                    searchElement = false;
                    break;
                }
            }
        }
        return feedList;
    }

    private boolean checkOutline(Outline outline) {
        if (outline.getType() != null && outline.getUrl() != null) {
            for (PodcastChannelModel channel : this.podcastChannelContainer.getPodcastChannels(PodcastNavigationViewType.Podcast)) {
                if (!channel.getPodcastFeedUrl().equalsIgnoreCase(outline.getUrl())) continue;
                return false;
            }
            switch (outline.getType()) {
                case "json": {
                    outline.setFeedType(PodcastChannelFeedType.Audiothek);
                    break;
                }
                case "rss": {
                    outline.setFeedType(PodcastChannelFeedType.RSS);
                    break;
                }
                default: {
                    LOG.info("Import OPML: Unknown Feed Type - " + outline.getType());
                    return false;
                }
            }
            return true;
        }
        return false;
    }
}

